###Forecast at the aggregate level

##Setup
#Load ONS data
load("data/ONS2018_allc.RData")

#Load NPP data
load("data/ew_npp_2018.RData")

#Set age and cohort ranges
agerange <- 15:44
cohrange <- 1945:2003

#Indicate models fitted (and desired for plotting)
indmod <- c("9:1","2:1","1:1","1:2","1:9","1:0")
indTF <- c(F, F, T, F, T, F)  # change T to F depending on models fitted
mod2 <- indmod[which(indTF)]
type <- c(2:6,1)[which(indTF)]

#Indicate backtesting models fitted (and desired for plotting)
indTFb <- c(F, F, T, F, F, F)  # change T to F depending on models fitted
mod2b <- indmod[which(indTFb)]
typeb <- c(2:6,1)[which(indTFb)]

#Combine observed and projected exposures
ons <- ONS_expos_dat[[5]] %>% rename(age=Group.1,coh=Group.2,N=x) %>%
  mutate(yr=age+coh) %>% arrange(coh,age)
allexp <- rbind(ons[,c("age","coh","yr","N")],npp[,c("age","coh","yr","N")])

ACexpmat <- data.frame(expand.grid(age=agerange,coh=cohrange))
ACexpmat$yr <- ACexpmat$age+ACexpmat$coh
ACexpmat %<>% left_join(allexp)

#Create lists to store results
cfrdat <- asfrdat <- list()


##Marginalize across parity
files <- c(paste0("output/ACprob_",gsub(":","_",mod2),".RData"),
           paste0("output/ACprob_",gsub(":","_",mod2b),"_2013.RData"))

for (f in 1:length(files)) {
  print(f)
  cfrdat[[f]] <- matrix(0,length(cohrange),1000)
  asfrdat[[f]] <- matrix(0,length(agerange)*length(cohrange),1000)
  load(files[f])
  set.seed(1)
  for (i in 1:1000) {
    print(i)
    tmp <- psurvf[[i]]
    tmp$N <- ACexpmat$N
    tmp$asfr <- tmp$btot <- tmp$b3 <- tmp$b2 <- tmp$b1 <- tmp$b0 <- tmp$E3 <- tmp$E2 <- tmp$E1 <- tmp$E0 <- NA
    bind <- tail(1:ncol(tmp),4)-2
    eind <- bind-4
    pind <- eind-5
    for (j in unique(tmp$coh)) {
      tmp2 <- tmp %>% filter(coh==j)
      tmp2[1,eind] <- c(tmp2[1,"N"],0,0,0)
      for (k in 2:(nrow(tmp2)+1)) {
        tmp2[k-1,bind[1]] <- ifelse(tmp2[k-1,eind[1]]>0, rbinom(1,tmp2[k-1,eind[1]],tmp2[k-1,pind[1]]),0)
        tmp2[k-1,bind[2]] <- ifelse(tmp2[k-1,eind[2]]>0, rbinom(1,tmp2[k-1,eind[2]],tmp2[k-1,pind[2]]),0)
        tmp2[k-1,bind[3]] <- ifelse(tmp2[k-1,eind[3]]>0, rbinom(1,tmp2[k-1,eind[3]],tmp2[k-1,pind[3]]),0)
        tmp2[k-1,bind[4]] <- ifelse(tmp2[k-1,eind[4]]>0, rbinom(1,tmp2[k-1,eind[4]],tmp2[k-1,pind[4]]),0)
        if (k<=nrow(tmp2)) {
          tmp2[k,eind[1]] <- round(tmp2[k,"N"]*(tmp2[k-1,eind[1]]-tmp2[k-1,bind[1]])/tmp2[k-1,"N"],0)
          tmp2[k,eind[2]] <- round(tmp2[k,"N"]*(tmp2[k-1,eind[2]]-tmp2[k-1,bind[2]]+tmp2[k-1,bind[1]])/tmp2[k-1,"N"],0)
          tmp2[k,eind[3]] <- round(tmp2[k,"N"]*(tmp2[k-1,eind[3]]-tmp2[k-1,bind[3]]+tmp2[k-1,bind[2]])/tmp2[k-1,"N"],0)
          tmp2[k,eind[4]] <- round(tmp2[k,"N"]*(tmp2[k-1,eind[4]]+tmp2[k-1,bind[3]])/tmp2[k-1,"N"],0)
        }
        tmp2$btot <- rowSums(tmp2[,bind])
        tmp2$asfr <- tmp2$btot/tmp2$N
        tmp[tmp$coh==j,] <- tmp2
      }
    }
    cfrdat[[f]][,i] <- aggregate(tmp$asfr~tmp$coh,FUN=sum)[,2]
    asfrdat[[f]][,i] <- tmp$asfr
  }
}

##Save output
save(cfrdat,asfrdat,file="output/agg_forecast.RData")
