###Model T|A,(Q)

##Setup
supp.labsq2b <- c("< A Level","At least A Level")
names(supp.labsq2b) <- c(1,2)
supp.labsq3b <- c("< GCSE","GCSE/A Level","Degree")
names(supp.labsq3b) <- c(1,2,3)
supp.labsp <- c("Parity 1","Parity 2","Parity 3+")
names(supp.labsp) <- c(1,2,3)
agerange <- 15:44
source("r/model_TAQ_functions.r")


##Parity 1 modelling
#Prepare data for modelling
newdata1 <- aggregate(gapc_1 ~ age_1 + qualf2b_1, FUN = function(x) c(y=length(x), t1=length(x[x==1]), t2=length(x[x==2]), t3=length(x[x==3]), t4=length(x[x==4]), t5=length(x[x==5]), t6=length(x[x==6]), t7=length(x[x==7]), t8=length(x[x==8]), t9=length(x[x==9]), t10=length(x[x==10]), t11=length(x[x==11])), subset = coh_1 <= 1982)
newdata1 <- data.frame(newdata1$age_1,newdata1$qualf2b_1,newdata1$gapc_1)
newdata1$yw <- aggregate(weights_1st ~ age_1 + qualf2b_1, FUN = sum, subset = coh_1 <= 1982)$weights_1st
newdata1$wtmult <- newdata1$yw/newdata1$y
colnames(newdata1) <- c("a","q","y",paste0(1:11),"yw","wtmult")
newdata1.1 <- newdata1[newdata1$q==1,]
newdata1.2 <- newdata1[newdata1$q==2,]
rownames(newdata1.1) <- newdata1.1$a
rownames(newdata1.2) <- newdata1.2$a

y1 <- newdata1.1[,paste0(1:11)]
y2 <- newdata1.2[,paste0(1:11)]
Na <- nrow(y1)
Nab <- nrow(y1)+1
a <- as.numeric(rownames(y1))-median(15:44)
a2 <- a^2
ab <- y1
for (i in 3:11) ab[,i] <- c(rep(0,i-3),1:(Na-(i-3)))
ab[,2] <- 2:(Na+1)
ab <- ab[,-1]
ab[ab==0] <- 1
wt1 <- newdata1.1[rownames(y1),"wtmult"]
wt2 <- newdata1.2[rownames(y2),"wtmult"]

standata <- list(Na=Na, Nab=Nab, y1=y1, y2=y2, a=a, a2=a2, ab=ab, wt1=wt1, wt2=wt2)

#Fit models
for (i in c(paste0(5,letters[1:4]), paste0(6,letters[1:8]),"6f.1","6f.2")) {
  cat("Fitting Model",i)
  stanout <- stan(file=paste0("stan/p1_TAQ_",i,".stan"),data=standata,chains=1,iter=2000)
  save(stanout,file=paste0("output/p1_TAQ_",i,".RData"))
}

#Compare models
files1 <- paste0("output/p1_TAQ_",
                 c(paste0(5,letters[1:4]), paste0(6,letters[1:8]),"6f.1","6f.2"),".RData",sep="")
res1 <- sumfunc1(files1)
chi1w2 <- round(chifunc(res1,newdata1),2)
p1 <- c(10+Nab,20+Nab,10+2*Nab,20+2*Nab,
        10+10+Nab,20+10+Nab,10+20+Nab,10+10+2*Nab,
        20+20+Nab,20+10+2*Nab,10+20+2*Nab,20+20+2*Nab,
        20+10+2*Nab+1,20+10+2*Nab+2)
df1 <- 2*(sum(2:9)+10*(Na-8)) - p1
qchi1 <- round(qchisq(0.95,df1),2)
BIC1 <- round(BICfunc(res1,newdata1,p1),2)


#Parity 2
newdata2 <- aggregate(gapc_2 ~ age_2 + qualf3b_2, FUN = function(x) c(y=length(x), t1=length(x[x==1]), t2=length(x[x==2]), t3=length(x[x==3]), t4=length(x[x==4]), t5=length(x[x==5]), t6=length(x[x==6]), t7=length(x[x==7]), t8=length(x[x==8]), t9=length(x[x==9]), t10=length(x[x==10]), t11=length(x[x==11])), subset = coh_2 <= 1982)
newdata2 <- data.frame(newdata2$age_2,newdata2$qualf3b_2,newdata2$gapc_2)
newdata2$yw <- aggregate(weights_2st ~ age_2 + qualf3b_2, FUN = sum, subset = coh_2 <= 1982)$weights_2st
newdata2$wtmult <- newdata2$yw/newdata2$y
colnames(newdata2) <- c("a","q","y",paste0(1:11),"yw","wtmult")
newdata2.1 <- newdata2[newdata2$q==1,]
newdata2.2 <- newdata2[newdata2$q==2,]
newdata2.3 <- newdata2[newdata2$q==3,]
newdata2.1 <- rbind(0,0,newdata2.1)
newdata2.2 <- rbind(0,0,newdata2.2)
newdata2.3 <- rbind(0,0,newdata2.3)
rownames(newdata2.1) <- agerange
rownames(newdata2.2) <- agerange
rownames(newdata2.3) <- agerange
newdata22 <- rbind(newdata2.1,newdata2.2,newdata2.3)

y1 <- newdata2.1[,paste0(1:11)]
y2 <- newdata2.2[,paste0(1:11)]
y3 <- newdata2.3[,paste0(1:11)]
Na <- nrow(y1)
Nab <- nrow(y1)+1
a <- as.numeric(rownames(y1))-median(17:44)
a2 <- a^2
ab <- y1
for (i in 3:11) ab[,i] <- c(rep(0,i-3),1:(Na-(i-3)))
ab[,2] <- 2:(Na+1)
ab <- ab[,-1]
ab[ab==0] <- 1
wt1 <- newdata2.1[rownames(y1),"wtmult"]
wt2 <- newdata2.2[rownames(y2),"wtmult"]
wt3 <- newdata2.3[rownames(y3),"wtmult"]

standata <- list(Na=Na, Nab=Nab, y1=y1, y2=y2, y3=y3, a=a, ab=ab, a2=a2, wt1=wt1, wt2=wt2, wt3=wt3)

#Fit models
for (i in c(paste0(5,letters[1:4]), paste0(6,letters[1:8]),"5d.2")) {
  cat("Fitting Model",i)
  stanout <- stan(file=paste0("stan/p2_TAQ_",i,".stan"),data=standata,chains=1,iter=2000)
  save(stanout,file=paste0("output/p2_TAQ_",i,".RData"))
}

#Compare models
files2 <- paste0("output/p2_TAQ_",
                 c(paste0(5,letters[1:4]), paste0(6,letters[1:8]),"5d.2"),".RData",sep="")
res2 <- sumfunc2(files2)
chi2w2 <- round(chifunc(res2,newdata22),2)
p2 <- c(10+Nab,30+Nab,10+3*Nab,30+3*Nab,
        10+10+Nab,30+10+Nab,10+30+Nab,10+10+3*Nab,
        30+30+Nab,30+10+3*Nab,10+30+3*Nab,30+30+3*Nab,
        30+3*Nab+1)
df2 <- 3*(sum(4:9)+10*(Na-6-2)) - p2
qchi2 <- round(qchisq(0.95,df2),2)
BIC2 <- round(BICfunc(res2,newdata22,p2),2)


#Parity 3+
newdata3 <- aggregate(gapc_3 ~ age_3, FUN = function(x) c(y=length(x), t1=length(x[x==1]), t2=length(x[x==2]), t3=length(x[x==3]), t4=length(x[x==4]), t5=length(x[x==5]), t6=length(x[x==6]), t7=length(x[x==7]), t8=length(x[x==8]), t9=length(x[x==9]), t10=length(x[x==10]), t11=length(x[x==11])))
newdata3 <- data.frame(newdata3$age_3,newdata3$gapc_3)
newdata3$yw <- aggregate(weights_3st ~ age_3, FUN = sum)$weights_3st
newdata3$wtmult <- newdata3$yw/newdata3$y
colnames(newdata3) <- c("a","y",paste0(1:11),"yw","wtmult")
newdata3 <- rbind(0,0,0,newdata3)
rownames(newdata3) <- agerange

y <- newdata3[,paste0(1:11)]
Na <- nrow(y)
Nab <- nrow(y)+1
a <- as.numeric(rownames(y))-median(18:44)
a2 <- a^2
ab <- y
for (i in 3:11) ab[,i] <- c(rep(0,i-3),1:(Na-(i-3)))
ab[,2] <- 2:(Na+1)
ab <- ab[,-1]
ab[ab==0] <- 1
wt <- newdata3[paste(rownames(y)),"wtmult"]

standata <- list(Na=Na, Nab=Nab, y=y, a=a, a2=a2, ab=ab, wt=wt)

#Fit models
for (i in c(paste0(1:6,"a"), "5a.2")) {
  cat("Fitting Model",i)
  stanout <- stan(file=paste0("stan/p3_TA_",i,".stan"),data=standata,chains=1,iter=2000)
  save(stanout,file=paste0("output/p3_TA_",i,".RData"))
}

#Compare models
files3 <- paste0("output/p3_TA_",
                 c(paste0(1:6,"a"), "5a.2"),".RData",sep="")
res3 <- sumfunc3(files3)
chi3w2 <- round(chifunc(res3,newdata3),2)
p3 <- c(10,10,20,30,10+Nab,20+Nab,10+Nab+1)
df3 <- sum(5:9)+10*(Na-5-3) - p3
qchi3 <- round(qchisq(0.95,df3),2)
BIC3 <- round(BICfunc(res3,newdata3,p3),2)
