###Model T|A,(Q) functions

##Parity 1
#Summary function
sumfunc1 <- function(files) {
  propsa <- list()
  for (i in 1:length(files)) {
    load(files[i])
    theta3_1 <- extract(stanout,pars="theta3_1",permuted=F)
    theta4_1 <- extract(stanout,pars="theta4_1",permuted=F)
    theta5_1 <- extract(stanout,pars="theta5_1",permuted=F)
    theta6_1 <- extract(stanout,pars="theta6_1",permuted=F)
    theta7_1 <- extract(stanout,pars="theta7_1",permuted=F)
    theta8_1 <- extract(stanout,pars="theta8_1",permuted=F)
    theta9_1 <- extract(stanout,pars="theta9_1",permuted=F)
    theta10_1 <- extract(stanout,pars="theta10_1",permuted=F)
    theta11_1 <- extract(stanout,pars="theta11_1",permuted=F)
    theta3_2 <- extract(stanout,pars="theta3_2",permuted=F)
    theta4_2 <- extract(stanout,pars="theta4_2",permuted=F)
    theta5_2 <- extract(stanout,pars="theta5_2",permuted=F)
    theta6_2 <- extract(stanout,pars="theta6_2",permuted=F)
    theta7_2 <- extract(stanout,pars="theta7_2",permuted=F)
    theta8_2 <- extract(stanout,pars="theta8_2",permuted=F)
    theta9_2 <- extract(stanout,pars="theta9_2",permuted=F)
    theta10_2 <- extract(stanout,pars="theta10_2",permuted=F)
    theta11_2 <- extract(stanout,pars="theta11_2",permuted=F)
    propsb1 <- newdata1.1[,paste(1:11)]
    propsb1[1,1:3] <- apply(theta3_1[,1,],2,mean)
    propsb1[2,1:4] <- apply(theta4_1[,1,],2,mean)
    propsb1[3,1:5] <- apply(theta5_1[,1,],2,mean)
    propsb1[4,1:6] <- apply(theta6_1[,1,],2,mean)
    propsb1[5,1:7] <- apply(theta7_1[,1,],2,mean)
    propsb1[6,1:8] <- apply(theta8_1[,1,],2,mean)
    propsb1[7,1:9] <- apply(theta9_1[,1,],2,mean)
    propsb1[8,1:10] <- apply(theta10_1[,1,],2,mean)
    propsb1[9:nrow(propsb1),] <- matrix(apply(theta11_1[,1,],2,mean),nrow=11,byrow=F)
    propsb2 <- newdata1.2[,paste(1:11)]
    propsb2[1,1:3] <- apply(theta3_2[,1,],2,mean)
    propsb2[2,1:4] <- apply(theta4_2[,1,],2,mean)
    propsb2[3,1:5] <- apply(theta5_2[,1,],2,mean)
    propsb2[4,1:6] <- apply(theta6_2[,1,],2,mean)
    propsb2[5,1:7] <- apply(theta7_2[,1,],2,mean)
    propsb2[6,1:8] <- apply(theta8_2[,1,],2,mean)
    propsb2[7,1:9] <- apply(theta9_2[,1,],2,mean)
    propsb2[8,1:10] <- apply(theta10_2[,1,],2,mean)
    propsb2[9:nrow(propsb2),] <- matrix(apply(theta11_2[,1,],2,mean),nrow=11,byrow=F)
    propsa[[i]] <- as.matrix(rbind(propsb1,propsb2))
  }
  propsa
}

#Chi-square function
chifunc <- function(res,newdata) {
  chi <- numeric()
  for (i in 1:length(res)) {
    pred <- res[[i]]
    predc <- pred * newdata[,"yw"]
    chires <- (newdata[,paste(1:11)] * newdata[,"wtmult"] - predc)/sqrt(predc)
    chi[i] <- sum(chires^2,na.rm=T)
  }
  chi
}

#BIC function
BICfunc <- function(res,newdata,p) {
  BIC <- numeric()
  for (i in 1:length(res))
    BIC[i] <- -2*sum(newdata$wtmult*(lfactorial(newdata[,"y"])-
                                       apply(lfactorial(newdata[,paste(1:11)]),1,sum)+
                                       apply(newdata[,paste(1:11)]*log(res[[i]][,]),1,sum,na.rm=T)))+
      p[i]*log(sum(newdata$wtmult*newdata[,"y"]))
  BIC
}


##Parity 2
#Summary function
sumfunc2 <- function(files) {
  propsa <- list()
  for (i in 1:length(files)) {
    load(files[i])
    Tprop_1 <- extract(stanout,pars="Tprop1",permuted=F)
    Tprop_2 <- extract(stanout,pars="Tprop2",permuted=F)
    Tprop_3 <- extract(stanout,pars="Tprop3",permuted=F)
    propsb1 <- data.frame(matrix(apply(Tprop_1[,1,],2,mean),Na,11,byrow=F))
    colnames(propsb1) <- 1:11; rownames(propsb1) <- agerange
    propsb2 <- data.frame(matrix(apply(Tprop_2[,1,],2,mean),Na,11,byrow=F))
    colnames(propsb2) <- 1:11; rownames(propsb2) <- agerange
    propsb3 <- data.frame(matrix(apply(Tprop_3[,1,],2,mean),Na,11,byrow=F))
    colnames(propsb3) <- 1:11; rownames(propsb3) <- agerange
    propsa[[i]] <- as.matrix(rbind(propsb1,propsb2,propsb3))
  }
  propsa
}


##Parity 3+
#Summary function
sumfunc3 <- function(files) {
  propsa <- list()
  for (i in 1:length(files)) {
    load(files[i])
    Tprop <- extract(stanout,pars="Tprop",permuted=F)
    propsb <- data.frame(matrix(apply(Tprop[,1,],2,mean),Na,11,byrow=F))
    colnames(propsb) <- 1:11; rownames(propsb) <- agerange
    propsa[[i]] <- as.matrix(propsb)
  }
  propsa
}
