###Parity 0 processing

##Setup
betadim <- 5*ncol(B_A2)+ncol(B_C2)+ncol(B_AC4)
Yhat <- extract(stanout,pars="Y_hat",permuted=F)
Yhatm0 <- apply(inv.logit(Yhat[,1,]),2,mean)
beta0 <- extract(stanout,pars="beta0",permuted=F)
betaQ <- extract(stanout,pars="betaQ",permuted=F)
beta <- extract(stanout,pars="beta",permuted=F)
theta <- extract(stanout,"theta",permuted=F)


##Construct unmarginalized probabilities
probfit <- list()
probfit[[1]] <- probfit[[2]] <- probfit[[3]] <- probfit[[4]] <- list()
for (i in 1:1000) {
  probfit[[1]][[i]] <- inv.logit(matrix(rep(beta0[i,1,1],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,9:16],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_C2all[C_indall,]%*%beta[i,1,41:48],length(agerange)),nrow=length(agerange),byrow=T)+
                                   matrix(B_ACfull3[,-ind]%*%beta[i,1,49:betadim],nrow=length(agerange),byrow=F))
  probfit[[2]][[i]] <- inv.logit(matrix(rep(beta0[i,1,1],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                   matrix(rep(betaQ[i,1,2],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,17:24],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_C2all[C_indall,]%*%beta[i,1,41:48],length(agerange)),nrow=length(agerange),byrow=T)+
                                   matrix(B_ACfull3[,-ind]%*%beta[i,1,49:betadim],nrow=length(agerange),byrow=F))
  probfit[[3]][[i]] <- inv.logit(matrix(rep(beta0[i,1,1],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                   matrix(rep(betaQ[i,1,3],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,25:32],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_C2all[C_indall,]%*%beta[i,1,41:48],length(agerange)),nrow=length(agerange),byrow=T)+
                                   matrix(B_ACfull3[,-ind]%*%beta[i,1,49:betadim],nrow=length(agerange),byrow=F))
  probfit[[4]][[i]] <- inv.logit(matrix(rep(beta0[i,1,1],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                   matrix(rep(betaQ[i,1,4],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_A2[A_ind,]%*%beta[i,1,33:40],length(cohrange)),nrow=length(agerange),byrow=F)+
                                   matrix(rep(B_C2all[C_indall,]%*%beta[i,1,41:48],length(agerange)),nrow=length(agerange),byrow=T)+
                                   matrix(B_ACfull3[,-ind]%*%beta[i,1,49:betadim],nrow=length(agerange),byrow=F))
}
probfitm <- list()
for (i in 1:4) probfitm[[i]] <- Reduce("+",probfit[[i]])/1000
probfitlw <- probfitup <- probfitm
for (q in 1:4) {
  for (i in 1:length(agerange)) {
    for (j in 1:length(cohrange)) {
      tmp <- numeric()
      for (k in 1:1000) tmp[k] <- probfit[[q]][[k]][i,j]
      probfitlw[[q]][i,j] <- quantile(tmp,p=0.025)
      probfitup[[q]][i,j] <- quantile(tmp,p=0.975)
    }
  }
}
probdat0 <- data.frame(parity=p,age=rep(rep(agerange,length(cohrange)),4),
                       coh=rep(rep(cohrange,each=length(agerange)),4),
                       qualf=rep(1:4,each=length(cohrange)*length(agerange)),
                       fit=as.vector(unlist(probfitm)),
                       lower=as.vector(unlist(probfitlw)),
                       upper=as.vector(unlist(probfitup)))


##Construct marginalized probabilities
data0f <- expand.grid(age=agerange,coh=cohrange,qualf=1:4)
B_A2f <- B_A2[A_ind[data0f$age-14],]
B_A21f <- B_A22f <- B_A23f <- B_A24f <- B_A2f
B_A21f[which(data0f$qualf!=1),] <- 0
B_A22f[which(data0f$qualf!=2),] <- 0
B_A23f[which(data0f$qualf!=3),] <- 0
B_A24f[which(data0f$qualf!=4),] <- 0
Xf <- cbind(B_A2f,B_A21f,B_A22f,B_A23f,B_A24f,
            B_C2all[C_indall[data0f$coh-1944],],
            B_ACfull3[rep(1:nrow(B_ACfull3),4),-ind])
Nf <- nrow(data0f)
Nm <- length(agerange)*length(cohrange)
ACind <- 1:nrow(B_ACfull3)
Xqf <- matrix(0,Nf,4)
for (q in 1:4) Xqf[,q] <- ifelse(data0f$qualf==q,1,0)

thetaf <- inv.logit(matrix(rep(beta0,Nf),ncol=1000,byrow=T)+
                      Xf%*%t(beta[,1,])+
                      Xqf%*%t(betaQ[,1,]))
psurvf <- matrix(0,1000,Nm)
for (j in 1:1000) {
  thetaj <- matrix(theta[j,1,],ncol=4,byrow=F)
  for (i in 1:Nm) {
    psurvf[j,i] <- thetaj[ACind[i],1]*thetaf[i,j]+
      thetaj[ACind[i],2]*thetaf[Nm+i,j]+
      thetaj[ACind[i],3]*thetaf[2*Nm+i,j]+
      thetaj[ACind[i],4]*thetaf[3*Nm+i,j]
  }
}


##Extract results
results$probdat[[n]] <- probdat0
results$psurvf[[n]] <- psurvf
results$psurvfm[[n]] <- apply(psurvf,2,mean)
results$psurvfl[[n]] <- apply(psurvf,2,quantile,p=0.025)
results$psurvfu[[n]] <- apply(psurvf,2,quantile,p=0.975)
