###Parity 1 GAM setup

##Setup
agerange <- 15:44
cohrange <- 1945:2003
No <- 9
Nn <- No-1
Nn2 <- Nn^2
data1 <- groupfunc("birth.bin_1",c("age_1", "coh_1", "gapc_1", "qualf2bimp_1"))
data1w <- groupfuncw("weights_1st",c("age_1", "coh_1", "gapc_1", "qualf2bimp_1"))
N <- nrow(data1)
succ <- data1$succ
tot <- data1$n


##Indexes
A_ind <- indexfunc(data1$age_1)
C_ind <- indexfunc(data1$coh_1); C_ind <- C_ind[which(!is.na(C_ind))]
C_indall <- c(C_ind,nrow(data1)+1:length(setdiff(cohrange,unique(data1$coh_1))))
C_indall <- C_indall[order(c(unique(data1$coh_1),setdiff(cohrange,unique(data1$coh_1))))]
T_ind <- indexfunc(data1$gapc_1)


##Basis functions
#Unconstrained
B_A1 <- bbase(data1$age_1, n.knots=No-2, deg=3)
B_C1 <- bbase(c(data1$coh_1,setdiff(cohrange,unique(data1$coh_1))), n.knots=No-2, deg=3)
B_T1 <- bbase(data1$gapc_1, n.knots=No-2, deg=3)

#Constrained
B_A2 <- newXfunc2(B_A1)$newX
st0ind <- 1:nrow(data1)
B_C2all <- newXfunc3(B_C1,st0ind)$newX
B_C2 <- B_C2all[st0ind,]
B_T2 <- newXfunc2(B_T1)$newX

#Reparameterised
B_A3 <- eqXfunc(data1, "age_1", No, B_A1, st0ind)$newX
B_C3all <- eqXfunc(data1, "coh_1", No, B_C1, st0ind)$newX
B_C3 <- B_C3all[st0ind,]

B_AC3 <- matrix(0,N,Nn2)
k <- 1
for (i in 1:Nn) {
  for (j in 1:Nn) {
    B_AC3[,k] <- B_A3[,j]*B_C3[,i]
    k <- k+1 
  }
}

B_Afull3 <- B_A3[rep(A_ind,length(cohrange)),]
B_Cfull3 <- B_C3all[rep(C_indall,each=length(agerange)),]
B_ACfull3 <- matrix(0,length(cohrange)*length(agerange),Nn2)
k <- 1
for (i in 1:Nn) {
  for (j in 1:Nn) {
    B_ACfull3[,k] <- B_Afull3[,j]*B_Cfull3[,i]
    k <- k+1 
  }
}

B_AC4 <- B_AC3


##Penalties
#Unconstrained
D <- diff(diag(No),1)
S <- t(D)%*%D

#Constrained
maXX <- norm(B_A1,type="I")^2 #square of infinity norm (maximum absolute row sum)
maS <- norm(S,type="O")/maXX #divide one norm (maximum absolute column sum) by maXX
S_A1 <- S/maS #divide original penalty matrix by maS
S.scale_A1 <- maS #4
Z <- newXfunc2(B_A1)$Z
S_A2 <- t(Z)%*%S_A1%*%Z

maXX <- norm(B_C1,type="I")^2 #square of infinity norm (maximum absolute row sum)
maS <- norm(S,type="O")/maXX #divide one norm (maximum absolute column sum) by maXX
S_C1 <- S/maS #divide original penalty matrix by maS
S.scale_C1 <- maS #4
Z <- newXfunc3(B_C1,st0ind)$Z
S_C2 <- t(Z)%*%S_C1%*%Z

maXX <- norm(B_T1,type="I")^2 #square of infinity norm (maximum absolute row sum)
maS <- norm(S,type="O")/maXX #divide one norm (maximum absolute column sum) by maXX
S_T1 <- S/maS #divide original penalty matrix by maS
S.scale_T1 <- maS #4
Z <- newXfunc2(B_T1)$Z
S_T2 <- t(Z)%*%S_T1%*%Z

#Reparameterised
XPA <- eqXfunc(data1, "age_1", No, B_A1, st0ind)$XP
XPC <- eqXfunc(data1, "coh_1", No, B_C1, st0ind)$XP
S_A3 <- t(XPA)%*%S_A2%*%XPA
S_C3 <- t(XPC)%*%S_C2%*%XPC
S_A4 <- S_A3/eigen(S_A3, symmetric = TRUE, only.values = TRUE)$values[1]
S_C4 <- S_C3/eigen(S_C3, symmetric = TRUE, only.values = TRUE)$values[1]
S_A5 <- kronecker(diag(Nn),S_A4)
S_C5 <- kronecker(S_C4,diag(Nn))

maXX <- norm(B_AC3,type="I")^2
maS <- norm(S_A5,type="O")/maXX
S_AF <- S_A5/maS
S.scale_A2 <- maS

maXX <- norm(B_AC3,type="I")^2
maS <- norm(S_C5,type="O")/maXX
S_CF <- S_C5/maS
S.scale_C2 <- maS
