###Parity 1 processing

##Setup
betadim <- 3*ncol(B_A2)+ncol(B_C2)+ncol(B_T2)+ncol(B_AC4)
Yhat <- extract(stanout,pars="Y_hat",permuted=F)
Yhatm1 <- apply(inv.logit(Yhat[,1,]),2,mean)
beta0 <- extract(stanout,pars="beta0",permuted=F)
betaQ <- extract(stanout,pars="betaQ",permuted=F)
beta <- extract(stanout,pars="beta",permuted=F)
theta <- extract(stanout,"theta",permuted=F)
Tprop1 <- extract(stanout,"Tprop1",permuted=F)
Tprop2 <- extract(stanout,"Tprop2",permuted=F)


##Construct unmarginalized probabilities
probfit1 <- probfit2 <- list()
for (t in 1:11) {
  probfit1[[t]] <- probfit2[[t]] <- list()
  for (i in 1:1000) {
    probfit1[[t]][[i]] <- inv.logit(matrix(rep(beta0[i,1,1],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                      matrix(rep(B_A2[A_ind,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
                                      matrix(rep(B_A2[A_ind,]%*%beta[i,1,9:16],length(cohrange)),nrow=length(agerange),byrow=F)+
                                      matrix(rep(B_C2all[C_indall,]%*%beta[i,1,25:32],length(agerange)),nrow=length(agerange),byrow=T)+
                                      matrix(rep(B_T2[T_ind[t],]%*%beta[i,1,33:40],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                      matrix(B_ACfull3[,-ind]%*%beta[i,1,41:betadim],nrow=length(agerange),byrow=F))
    probfit2[[t]][[i]] <- inv.logit(matrix(rep(beta0[i,1,1],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                      matrix(rep(betaQ[i,1,2],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                      matrix(rep(B_A2[A_ind,]%*%beta[i,1,1:8],length(cohrange)),nrow=length(agerange),byrow=F)+
                                      matrix(rep(B_A2[A_ind,]%*%beta[i,1,17:24],length(cohrange)),nrow=length(agerange),byrow=F)+
                                      matrix(rep(B_C2all[C_indall,]%*%beta[i,1,25:32],length(agerange)),nrow=length(agerange),byrow=T)+
                                      matrix(rep(B_T2[T_ind[t],]%*%beta[i,1,33:40],length(cohrange)*length(agerange)),nrow=length(agerange))+
                                      matrix(B_ACfull3[,-ind]%*%beta[i,1,41:betadim],nrow=length(agerange),byrow=F))

  }
}
probfitm1 <- probfitm2 <- list()
for (t in 1:11) {
  probfitm1[[t]] <- Reduce("+",probfit1[[t]])/1000
  probfitm2[[t]] <- Reduce("+",probfit2[[t]])/1000
}
probfitlw1 <- probfitlw2 <- probfitup1 <- probfitup2 <- probfitm1
for (t in 1:11) {
  for (i in 1:length(agerange)) {
    for (j in 1:length(cohrange)) {
      tmp1 <- tmp2 <- numeric()
      for (k in 1:1000) {
        tmp1[k] <- probfit1[[t]][[k]][i,j]
        tmp2[k] <- probfit2[[t]][[k]][i,j]
      }
      probfitlw1[[t]][i,j] <- quantile(tmp1,p=0.025)
      probfitlw2[[t]][i,j] <- quantile(tmp2,p=0.025)
      probfitup1[[t]][i,j] <- quantile(tmp1,p=0.975)
      probfitup2[[t]][i,j] <- quantile(tmp2,p=0.975)
    }
  }
}
probdat1 <- data.frame(parity=p,age=rep(rep(agerange,length(cohrange)),22),
                       coh=rep(rep(cohrange,each=length(agerange)),22),
                       gapc=rep(rep(1:11,each=length(agerange)*length(cohrange)),2),
                       qualf=rep(1:2,each=length(cohrange)*length(agerange)*11),
                       fit=c(as.vector(unlist(probfitm1)),as.vector(unlist(probfitm2))),
                       lower=c(as.vector(unlist(probfitlw1)),as.vector(unlist(probfitlw2))),
                       upper=c(as.vector(unlist(probfitup1)),as.vector(unlist(probfitup2))))


##Construct marginalized probabilities
data1f <- expand.grid(age=agerange,coh=cohrange,gapc=1:11,qualf=1:2)
B_A2f <- B_A2[A_ind[data1f$age-14],]
B_A21f <- B_A22f <- B_A2f
B_A21f[which(data1f$qualf!=1),] <- 0
B_A22f[which(data1f$qualf!=2),] <- 0
Xf <- cbind(B_A2f,B_A21f,B_A22f,
            B_C2all[C_indall[data1f$coh-1944],],
            B_T2[T_ind[data1f$gapc],],
            B_ACfull3[rep(1:nrow(B_ACfull3),22),-ind])
Nf <- nrow(data1f)
Nm <- length(agerange)*length(cohrange)
Afind <- c(data1f$age-14)[1:Nm]
ACind <- 1:nrow(B_ACfull3)
Xqf <- matrix(0,Nf,2)
for (q in 1:2) Xqf[,q] <- ifelse(data1f$qualf==q,1,0)

thetaf <- inv.logit(matrix(rep(beta0,Nf),ncol=1000,byrow=T)+
                      Xf%*%t(beta[,1,])+
                      Xqf%*%t(betaQ[,1,]))
psurvf <- matrix(0,1000,Nm)
for (j in 1:1000) {
  Tprop1j <- matrix(Tprop1[j,1,],ncol=11,byrow=F)
  Tprop2j <- matrix(Tprop2[j,1,],ncol=11,byrow=F)
  thetaj <- matrix(theta[j,1,],ncol=2,byrow=F)
  for (i in 1:Nm) {
    psurvf[j,i] <- Tprop1j[Afind[i],1]*thetaj[ACind[i],1]*thetaf[i,j]+
      Tprop1j[Afind[i],2]*thetaj[ACind[i],1]*thetaf[Nm+i,j]+
      Tprop1j[Afind[i],3]*thetaj[ACind[i],1]*thetaf[2*Nm+i,j]+
      Tprop1j[Afind[i],4]*thetaj[ACind[i],1]*thetaf[3*Nm+i,j]+
      Tprop1j[Afind[i],5]*thetaj[ACind[i],1]*thetaf[4*Nm+i,j]+
      Tprop1j[Afind[i],6]*thetaj[ACind[i],1]*thetaf[5*Nm+i,j]+
      Tprop1j[Afind[i],7]*thetaj[ACind[i],1]*thetaf[6*Nm+i,j]+
      Tprop1j[Afind[i],8]*thetaj[ACind[i],1]*thetaf[7*Nm+i,j]+
      Tprop1j[Afind[i],9]*thetaj[ACind[i],1]*thetaf[8*Nm+i,j]+
      Tprop1j[Afind[i],10]*thetaj[ACind[i],1]*thetaf[9*Nm+i,j]+
      Tprop1j[Afind[i],11]*thetaj[ACind[i],1]*thetaf[10*Nm+i,j]+
      Tprop2j[Afind[i],1]*thetaj[ACind[i],2]*thetaf[11*Nm+i,j]+
      Tprop2j[Afind[i],2]*thetaj[ACind[i],2]*thetaf[12*Nm+i,j]+
      Tprop2j[Afind[i],3]*thetaj[ACind[i],2]*thetaf[13*Nm+i,j]+
      Tprop2j[Afind[i],4]*thetaj[ACind[i],2]*thetaf[14*Nm+i,j]+
      Tprop2j[Afind[i],5]*thetaj[ACind[i],2]*thetaf[15*Nm+i,j]+
      Tprop2j[Afind[i],6]*thetaj[ACind[i],2]*thetaf[16*Nm+i,j]+
      Tprop2j[Afind[i],7]*thetaj[ACind[i],2]*thetaf[17*Nm+i,j]+
      Tprop2j[Afind[i],8]*thetaj[ACind[i],2]*thetaf[18*Nm+i,j]+
      Tprop2j[Afind[i],9]*thetaj[ACind[i],2]*thetaf[19*Nm+i,j]+
      Tprop2j[Afind[i],10]*thetaj[ACind[i],2]*thetaf[20*Nm+i,j]+
      Tprop2j[Afind[i],11]*thetaj[ACind[i],2]*thetaf[21*Nm+i,j]
  }
}


##Extract results
results$probdat[[n]] <- probdat1
results$psurvf[[n]] <- psurvf
results$psurvfm[[n]] <- apply(psurvf,2,mean)
results$psurvfl[[n]] <- apply(psurvf,2,quantile,p=0.025)
results$psurvfu[[n]] <- apply(psurvf,2,quantile,p=0.975)
