###Plot Figures 11 and 13

##Setup
#Panel labels
supp.labst <- c("Unweighted","Weighted")
names(supp.labst) <- c(1, 2)

#Function to aggregate women by cohort and qualification level
scatterfunc <- function(w, c, q, ind, FUN) {
  data <- aggregate(w[ind], by = list(c[ind], as.factor(4 - q[ind])), FUN = FUN)
  data <- right_join(data, expand.grid(Group.1 = 1945:1992, Group.2 = as.factor(0:3)),
                     by = c("Group.1", "Group.2")) %>%
    mutate(x = replace_na(x, 0))
  data <- right_join(data, aggregate(w[ind], by = list(c[ind]), FUN = FUN), by = "Group.1")
  data$x <- data$x.x/data$x.y
  data
}


##Prepare unweighted and weighted distribution of (imputed) qualification by cohort 
#Qualification (original)
data <- scatterfunc(weights, coh, qualf4, l_ind, length)
data <- data[order(data$Group.2, data$Group.1), ]
dataw <- scatterfunc(weights, coh, qualf4, l_ind, sum)
dataw <- dataw[order(dataw$Group.2, dataw$Group.1), ]
ymax <- max(data$x)

#Imputed qualification
dataa <- scatterfunc(weights_st, coh, qualf4imp, l_ind, length)
dataa <- dataa[order(dataa$Group.2, dataa$Group.1), ]
dataaw <- scatterfunc(weights_st, coh, qualf4imp, l_ind, sum)
dataaw <- dataaw[order(dataaw$Group.2, dataaw$Group.1), ]
dataa$xorg <- data$x
dataaw$xorg <- dataw$x

#Combine into a single data frame
dataa2 <- rbind(data.frame(type = 1, dataa),
                data.frame(type = 2, dataaw))


##Plot Figure 11
plotfunc <- function(filename, dat) {
  png(file = filename, width = 15, height = 10, units = "cm", res = 400)
  print({
    ggplot(dat, aes(x = Group.1, y = x, color = Group.2)) +
      geom_point(size = 0.9) +
      geom_line(linetype = 2, size = 0.4) +
      geom_line(aes(x = Group.1[order(Group.2)],
                    y = unlist(tapply(x, Group.2, rollmean, k = 3, fill = NA, align = "right")),
                    color = sort(Group.2)), size = 0.8, show.legend = F) +
      labs(x = "Cohort", y = "Proportion", color = "Highest educational qualification") +
      scale_color_discrete(guide = guide_legend(reverse = TRUE), labels = c("Degree", "A Level", "GCSE", "< GCSE")) +
      scale_y_continuous(breaks = seq(0, 1 , 0.2)) +
      scale_x_continuous(limits = c(1945, 1992), breaks = seq(1945, 1990, 5),
                         minor_breaks = setdiff(1945:1992, seq(1945, 1990, 5)), expand = c(0.02, 0.02)) +
      coord_cartesian(ylim = c(0, ymax)) +
      theme_bw() + theme(legend.position = "bottom", text = element_text("Calibri"))
  })
  dev.off()  
}

plotfunc("plots/fig11.png", data)


##Plot Figure 13
plotfunc <- function(filename, dat) {
  png(file = filename, width = 17.5, height = 10, units = "cm", res = 400)
  print({
    ggplot(dat, aes(x = Group.1, y = x, color = Group.2)) +
      geom_line(aes(y = xorg), linetype = 2, linewidth = 0.4) +
      geom_point(aes(y = xorg), shape = 1, size = 0.9) +
      geom_point(size = 0.9) +
      geom_line() +
      geom_vline(aes(xintercept = cutoff)) + 
      labs(x = "Cohort", y = "Proportion", color = "Highest educational qualification") +
      scale_color_discrete(guide = guide_legend(reverse = TRUE),
                           labels = c("Degree", "A Level", "GCSE", "< GCSE")) +
      scale_y_continuous(breaks = seq(0, 1, 0.2)) +
      scale_x_continuous(limits = c(1945, 1992), breaks = seq(1945, 1990, 5),
                         minor_breaks=setdiff(1945:1992, seq(1945, 1990, 5)), expand = c(0.02, 0.02)) +
      coord_cartesian(ylim = c(0, ymax)) +
      theme_bw() + theme(legend.position = "bottom", text = element_text("Calibri")) +
      facet_wrap(~ type, labeller = labeller(type = supp.labst))
  })
  dev.off()  
}

plotfunc("plots/fig13.png", dataa2)
