###Plot Figures 16 and 17

##Setup
supp.labsq4 <- c("< GCSE","GCSE","A Level","Degree")
names(supp.labsq4) <- c(1,2,3,4)
supp.labsq2b <- c("< A Level","At least A Level")
names(supp.labsq2b) <- c(1,2)
supp.labsq3b <- c("< GCSE","GCSE/A Level","Degree")
names(supp.labsq3b) <- c(1,2,3)
supp.labsp <- c("Parity 0","Parity 1","Parity 2")
names(supp.labsp) <- c(0,1,2)
supp.labscov <- c("Age","Cohort")
names(supp.labscov) <- c("a","c")

##Extract age coefficients from initial chosen models
betaA123dat <- data.frame(Parity=rep(c(0,1,2),c(29*6,29,29*3)),
                          mod=c(rep(5:7,29*c(1,2,3)),rep(7,29),rep(c(5,7),c(29,29*2))),
                          qualf=factor(c(rep(3,29),rep(2:3,29),rep(1:3,29),rep(1,29),rep(2,29),rep(1:2,29))),
                          qualft=factor(c(rep(supp.labsq4[-c(1:3)],29),rep(supp.labsq4[-c(1:2)],29),rep(supp.labsq4[-1],29),
                                          rep(supp.labsq2b[-1],29),rep(supp.labsq3b[-c(1:2)],29),rep(supp.labsq3b[-1],29)),
                                        levels=c("GCSE","A Level","Degree","At least A Level","GCSE/A Level")),
                          cov=c(16:44,rep(16:44,each=2),rep(16:44,each=3),15:43,15:43,rep(15:43,each=2)),
                          mean=NA,lower=NA,upper=NA)

for (i in c(0,1,2)) {
  if (i==0) {
    j <- 5
    load(paste0("output/p",i,"_QAC_",j,".RData"))
  } 
  if (i==1) {
    j <- 7
    load(paste0("output/p",i,"_QAC_",j,".RData"))
  }
  if (i==2) {
    j <- 5
    load(paste0("output/p",i,"_QAC_",j,".RData"))
  }  
  if (1 %in% unique(betaA123dat$qualf[betaA123dat$Parity==i & betaA123dat$mod==j])) {
    betaA1 <- extract(stanout,pars="betaA1",permuted=F)
    betaA123dat$mean[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 1] <- apply(betaA1[,1,],2,mean)[-which(apply(betaA1[,1,],2,mean)==0)]
    betaA123dat$lower[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 1] <- apply(betaA1[,1,],2,quantile,p=0.025)[-which(apply(betaA1[,1,],2,mean)==0)]
    betaA123dat$upper[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 1] <- apply(betaA1[,1,],2,quantile,p=0.975)[-which(apply(betaA1[,1,],2,mean)==0)]
  }
  if (2 %in% unique(betaA123dat$qualf[betaA123dat$Parity==i & betaA123dat$mod==j])) {
    betaA2 <- extract(stanout,pars="betaA2",permuted=F)
    betaA123dat$mean[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 2] <- apply(betaA2[,1,],2,mean)[-which(apply(betaA2[,1,],2,mean)==0)]
    betaA123dat$lower[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 2] <- apply(betaA2[,1,],2,quantile,p=0.025)[-which(apply(betaA2[,1,],2,mean)==0)]
    betaA123dat$upper[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 2] <- apply(betaA2[,1,],2,quantile,p=0.975)[-which(apply(betaA2[,1,],2,mean)==0)]
  }
  if (3 %in% unique(betaA123dat$qualf[betaA123dat$Parity==i & betaA123dat$mod==j])) {
    betaA3 <- extract(stanout,pars="betaA3",permuted=F)
    betaA123dat$mean[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 3] <- apply(betaA3[,1,],2,mean)[-which(apply(betaA3[,1,],2,mean)==0)]
    betaA123dat$lower[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 3] <- apply(betaA3[,1,],2,quantile,p=0.025)[-which(apply(betaA3[,1,],2,mean)==0)]
    betaA123dat$upper[betaA123dat$Parity == i & betaA123dat$mod==j & betaA123dat$qualf == 3] <- apply(betaA3[,1,],2,quantile,p=0.975)[-which(apply(betaA3[,1,],2,mean)==0)]
  }
}


##Extract cohort coefficients from initial chosen models
betaC123dat <- data.frame(Parity=rep(c(0,1,2),c(37*5*3,37*3*1,37*4*2)),
                          mod=c(rep(3:7,each=37*3),rep(c(3:4,7),each=37*1),rep(c(3:5,7),each=37*2)),
                          qualf=factor(c(rep(1:3,37*5),rep(1,37*3),rep(1:2,37*4))),
                          qualft=factor(c(rep(supp.labsq4[-1],37*5),rep(supp.labsq2b[-1],37*3),rep(supp.labsq3b[-1],37*4)), levels=c("GCSE","A Level","Degree","At least A Level","GCSE/A Level")),
                          cov=c(rep(rep(1946:1982,each=3),5),rep(rep(1946:1982,each=1),3),rep(rep(1946:1982,each=2),4)),
                          mean=NA,lower=NA,upper=NA)
for (i in c(0,1,2)) {
  if (i==0) {
    j <- 5
    load(paste0("output/p",i,"_QAC_",j,".RData"))
  } 
  if (i==1) {
    j <- 7
    load(paste0("output/p",i,"_QAC_",j,".RData"))
  }
  if (i==2) {
    j <- 5
    load(paste0("output/p",i,"_QAC_",j,".RData"))
  }  
  betaC1 <- extract(stanout,pars="betaC1",permuted=F)
  if (i %in% c(0,2)) betaC2 <- extract(stanout,pars="betaC2",permuted=F)
  if (i == 0) betaC3 <- extract(stanout,pars="betaC3",permuted=F)
  betaC123dat$mean[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 1] <- apply(betaC1[,1,],2,mean)[-1]
  betaC123dat$lower[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 1] <- apply(betaC1[,1,],2,quantile,p=0.025)[-1]
  betaC123dat$upper[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 1] <- apply(betaC1[,1,],2,quantile,p=0.975)[-1]
  if (i %in% c(0,2)) {
    betaC123dat$mean[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 2] <- apply(betaC2[,1,],2,mean)[-1]
    betaC123dat$lower[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 2] <- apply(betaC2[,1,],2,quantile,p=0.025)[-1]
    betaC123dat$upper[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 2] <- apply(betaC2[,1,],2,quantile,p=0.975)[-1]
  }
  if (i == 0) {
    betaC123dat$mean[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 3] <- apply(betaC3[,1,],2,mean)[-1]
    betaC123dat$lower[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 3] <- apply(betaC3[,1,],2,quantile,p=0.025)[-1]
    betaC123dat$upper[betaC123dat$Parity == i & betaC123dat$mod==j & betaC123dat$qualf == 3] <- apply(betaC3[,1,],2,quantile,p=0.975)[-1]
  }
}


##Combine coefficients into a single data frame
coefdatall.ch <- data.frame(Parity=rep(c(0,1,2),c(3*37+29,37+29,2*37+29)),
                            coef=factor(c(rep(c("c","a"),c(3*37,29)),rep(c("c","a"),c(37,29)),rep(c("c","a"),c(2*37,29))),levels=c("c","a")),
                            cov=c(rep(1946:1982,3),16:44,1946:1982,15:43,rep(1946:1982,2),15:43),
                            qualf=factor(c(rep(c(1,2,3),each=37),rep(3,29),rep(1,37+29),rep(c(1,2),each=37),rep(2,29))),
                            qualft=factor(c(rep(supp.labsq4[-1],each=37),rep(supp.labsq4[4],29),rep(supp.labsq2b[-1],37+29),
                                            rep(supp.labsq3b[-1],each=37),rep(supp.labsq3b[3],each=29)),
                                          levels=c("GCSE","A Level","Degree","At least A Level","GCSE/A Level")))

coefdatall.chp0a <- left_join(coefdatall.ch,betaA123dat[betaA123dat$Parity==0 & betaA123dat$mod==5,-2],by=c("Parity","qualf","qualft","cov"))
coefdatall.chp1a <- left_join(coefdatall.ch,betaA123dat[betaA123dat$Parity==1 & betaA123dat$mod==7,-2],by=c("Parity","qualf","qualft","cov"))
coefdatall.chp2a <- left_join(coefdatall.ch,betaA123dat[betaA123dat$Parity==2 & betaA123dat$mod==5,-2],by=c("Parity","qualf","qualft","cov"))
coefdatall.chp0c <- left_join(coefdatall.ch,betaC123dat[betaC123dat$Parity==0 & betaC123dat$mod==5,-2],by=c("Parity","qualf","qualft","cov"))
coefdatall.chp1c <- left_join(coefdatall.ch,betaC123dat[betaC123dat$Parity==1 & betaC123dat$mod==7,-2],by=c("Parity","qualf","qualft","cov"))
coefdatall.chp2c <- left_join(coefdatall.ch,betaC123dat[betaC123dat$Parity==2 & betaC123dat$mod==5,-2],by=c("Parity","qualf","qualft","cov"))

coefdatall.ch$mean <- apply(cbind(coefdatall.chp0a$mean,coefdatall.chp1a$mean,coefdatall.chp2a$mean,
                                  coefdatall.chp0c$mean,coefdatall.chp1c$mean,coefdatall.chp2c$mean),1,sum,na.rm=T)
coefdatall.ch$lower <- apply(cbind(coefdatall.chp0a$lower,coefdatall.chp1a$lower,coefdatall.chp2a$lower,
                                   coefdatall.chp0c$lower,coefdatall.chp1c$lower,coefdatall.chp2c$lower),1,sum,na.rm=T)
coefdatall.ch$upper <- apply(cbind(coefdatall.chp0a$upper,coefdatall.chp1a$upper,coefdatall.chp2a$upper,
                                   coefdatall.chp0c$upper,coefdatall.chp1c$upper,coefdatall.chp2c$upper),1,sum,na.rm=T)
coefdatall.ch$upper2 <- coefdatall.ch$lower2 <- coefdatall.ch$mean2 <- NA
coefdatall.ch$upper3 <- coefdatall.ch$lower3 <- coefdatall.ch$mean3 <- NA


##Extract Variant 1 age and cohort coefficients
for (i in c(0,1,2)) {
  if (i==0) load(paste0("output/p",i,"_QAC_",5.1,".RData"))
  if (i==1) load(paste0("output/p",i,"_QAC_",7.1,".RData"))
  if (i==2) load(paste0("output/p",i,"_QAC_",5.1,".RData"))
  if (1 %in% coefdatall.ch$qualf[coefdatall.ch$Parity==i]) {
    betaC <- extract(stanout,pars="betaC",permuted=F)
    if ("a" %in% coefdatall.ch$coef[coefdatall.ch$Parity==i & coefdatall.ch$qualf==1]) {
      betaA1 <- extract(stanout,pars="betaA1",permuted=F)
      coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 1] <- apply(betaA1[,1,],2,mean)[-which(apply(betaA1[,1,],2,mean)==0)]
      coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 1] <- apply(betaA1[,1,],2,quantile,p=0.025)[-which(apply(betaA1[,1,],2,mean)==0)]
      coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 1] <- apply(betaA1[,1,],2,quantile,p=0.975)[-which(apply(betaA1[,1,],2,mean)==0)]
    }
    betaC1 <- extract(stanout,pars="betaC1",permuted=F)
    coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 1] <- apply(betaC1[,1,],2,mean)[-c(1,28)]
    coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 1] <- apply(betaC1[,1,],2,quantile,p=0.025)[-c(1,28)]
    coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 1] <- apply(betaC1[,1,],2,quantile,p=0.975)[-c(1,28)]
    betaCcc72 <- matrix(rep(betaC1[,1,28],11),nrow=nrow(betaC1),byrow=F) + matrix(betaC[,1,1])%*%t(matrix(c(8:18)+0.5))
    coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 1] <- apply(betaCcc72,2,mean)
    coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 1] <- apply(betaCcc72,2,quantile,p=0.025)
    coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 1] <- apply(betaCcc72,2,quantile,p=0.975)
  }
  if (2 %in% coefdatall.ch$qualf[coefdatall.ch$Parity==i]) {
    if ("a" %in% coefdatall.ch$coef[coefdatall.ch$Parity==i & coefdatall.ch$qualf==2]) {
      betaA2 <- extract(stanout,pars="betaA2",permuted=F)
      coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 2] <- apply(betaA2[,1,],2,mean)[-which(apply(betaA2[,1,],2,mean)==0)]
      coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 2] <- apply(betaA2[,1,],2,quantile,p=0.025)[-which(apply(betaA2[,1,],2,mean)==0)]
      coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 2] <- apply(betaA2[,1,],2,quantile,p=0.975)[-which(apply(betaA2[,1,],2,mean)==0)]
    }
    betaC2 <- extract(stanout,pars="betaC2",permuted=F)
    coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1972 & coefdatall.ch$qualf == 2] <- apply(betaC2[,1,],2,mean)[-which(apply(betaC2[,1,],2,mean)==0)]
    coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1972 & coefdatall.ch$qualf == 2] <- apply(betaC2[,1,],2,quantile,p=0.025)[-which(apply(betaC2[,1,],2,mean)==0)]
    coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1972 & coefdatall.ch$qualf == 2] <- apply(betaC2[,1,],2,quantile,p=0.975)[-which(apply(betaC2[,1,],2,mean)==0)]
    betaCcc72 <- matrix(rep(betaC2[,1,28],11),nrow=nrow(betaC2),byrow=F) + matrix(betaC[,1,2])%*%t(matrix(c(8:18)+0.5))
    coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 2] <- apply(betaCcc72,2,mean)
    coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 2] <- apply(betaCcc72,2,quantile,p=0.025)
    coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 2] <- apply(betaCcc72,2,quantile,p=0.975)
  }
  if (3 %in% coefdatall.ch$qualf[coefdatall.ch$Parity==i]) {
    betaA3 <- extract(stanout,pars="betaA3",permuted=F)
    betaC3 <- extract(stanout,pars="betaC3",permuted=F)
    coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 3] <- apply(betaA3[,1,],2,mean)[-which(apply(betaA3[,1,],2,mean)==0)]
    coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 3] <- apply(betaA3[,1,],2,quantile,p=0.025)[-which(apply(betaA3[,1,],2,mean)==0)]
    coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 3] <- apply(betaA3[,1,],2,quantile,p=0.975)[-which(apply(betaA3[,1,],2,mean)==0)]
    coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1972 & coefdatall.ch$qualf == 3] <- apply(betaC3[,1,],2,mean)[-which(apply(betaC3[,1,],2,mean)==0)]
    coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1972 & coefdatall.ch$qualf == 3] <- apply(betaC3[,1,],2,quantile,p=0.025)[-which(apply(betaC3[,1,],2,mean)==0)]
    coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1972 & coefdatall.ch$qualf == 3] <- apply(betaC3[,1,],2,quantile,p=0.975)[-which(apply(betaC3[,1,],2,mean)==0)]
    betaCcc72 <- matrix(rep(betaC3[,1,28],11),nrow=nrow(betaC3),byrow=F) + matrix(betaC[,1,3])%*%t(matrix(c(8:18)+0.5))
    coefdatall.ch$mean2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 3] <- apply(betaCcc72,2,mean)
    coefdatall.ch$lower2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 3] <- apply(betaCcc72,2,quantile,p=0.025)
    coefdatall.ch$upper2[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 3] <- apply(betaCcc72,2,quantile,p=0.975)
  }
}

coefdatall.ch[coefdatall.ch$cov %in% c(1973:1981),c("lower2","upper2")] <- NA
coefdatall.ch$mean2a <- ifelse(coefdatall.ch$cov %in% c(1973:1981),NA,coefdatall.ch$mean2)


##Extract Variant 2 age and cohort coefficients
for (i in c(0,1,2)) {
  if (i==0) load(paste0("output/p",i,"_QAC_",5.2,".RData"))
  if (i==1) load(paste0("output/p",i,"_QAC_",7.2,".RData"))
  if (i==2) load(paste0("output/p",i,"_QAC_",5.2,".RData"))
  if (1 %in% coefdatall.ch$qualf[coefdatall.ch$Parity==i]) {
    betaC <- extract(stanout,pars="betaC",permuted=F)
    if ("a" %in% coefdatall.ch$coef[coefdatall.ch$Parity==i & coefdatall.ch$qualf==1]) {
      betaA1 <- extract(stanout,pars="betaA1",permuted=F)
      coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 1] <- apply(betaA1[,1,],2,mean)[-which(apply(betaA1[,1,],2,mean)==0)]
      coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 1] <- apply(betaA1[,1,],2,quantile,p=0.025)[-which(apply(betaA1[,1,],2,mean)==0)]
      coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 1] <- apply(betaA1[,1,],2,quantile,p=0.975)[-which(apply(betaA1[,1,],2,mean)==0)]
    }
    betaC1 <- extract(stanout,pars="betaC1",permuted=F)
    coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 1] <- apply(betaC1[,1,],2,mean)[-c(1,28)]
    coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 1] <- apply(betaC1[,1,],2,quantile,p=0.025)[-c(1,28)]
    coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 1] <- apply(betaC1[,1,],2,quantile,p=0.975)[-c(1,28)]
    betaCcc72 <- matrix(rep(betaC1[,1,28],11),nrow=nrow(betaC1),byrow=F) + matrix(betaC[,1,1])%*%t(matrix(c(8:18)+0.5))
    coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 1] <- apply(betaCcc72,2,mean)
    coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 1] <- apply(betaCcc72,2,quantile,p=0.025)
    coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 1] <- apply(betaCcc72,2,quantile,p=0.975)
  }
  if (2 %in% coefdatall.ch$qualf[coefdatall.ch$Parity==i]) {
    if ("a" %in% coefdatall.ch$coef[coefdatall.ch$Parity==i & coefdatall.ch$qualf==2]) {
      betaA2 <- extract(stanout,pars="betaA2",permuted=F)
      coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 2] <- apply(betaA2[,1,],2,mean)[-which(apply(betaA2[,1,],2,mean)==0)]
      coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 2] <- apply(betaA2[,1,],2,quantile,p=0.025)[-which(apply(betaA2[,1,],2,mean)==0)]
      coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 2] <- apply(betaA2[,1,],2,quantile,p=0.975)[-which(apply(betaA2[,1,],2,mean)==0)]
    }
    betaC2 <- extract(stanout,pars="betaC2",permuted=F)
    coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 2] <- apply(betaC2[,1,],2,mean)[-c(1,28)]
    coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 2] <- apply(betaC2[,1,],2,quantile,p=0.025)[-c(1,28)]
    coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 2] <- apply(betaC2[,1,],2,quantile,p=0.975)[-c(1,28)]
    betaCcc72 <- matrix(rep(betaC2[,1,28],11),nrow=nrow(betaC2),byrow=F) + matrix(betaC[,1,2])%*%t(matrix(c(8:18)+0.5))
    coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 2] <- apply(betaCcc72,2,mean)
    coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 2] <- apply(betaCcc72,2,quantile,p=0.025)
    coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 2] <- apply(betaCcc72,2,quantile,p=0.975)
  }
  if (3 %in% coefdatall.ch$qualf[coefdatall.ch$Parity==i]) {
    betaA3 <- extract(stanout,pars="betaA3",permuted=F)
    betaC3 <- extract(stanout,pars="betaC3",permuted=F)
    coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 3] <- apply(betaA3[,1,],2,mean)[-which(apply(betaA3[,1,],2,mean)==0)]
    coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 3] <- apply(betaA3[,1,],2,quantile,p=0.025)[-which(apply(betaA3[,1,],2,mean)==0)]
    coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "a" & coefdatall.ch$qualf == 3] <- apply(betaA3[,1,],2,quantile,p=0.975)[-which(apply(betaA3[,1,],2,mean)==0)]
    coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 3] <- apply(betaC3[,1,],2,mean)[-c(1,28)]
    coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 3] <- apply(betaC3[,1,],2,quantile,p=0.025)[-c(1,28)]
    coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1946:1971 & coefdatall.ch$qualf == 3] <- apply(betaC3[,1,],2,quantile,p=0.975)[-c(1,28)]
    betaCcc72 <- matrix(rep(betaC3[,1,28],11),nrow=nrow(betaC3),byrow=F) + matrix(betaC[,1,3])%*%t(matrix(c(8:18)+0.5))
    coefdatall.ch$mean3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 3] <- apply(betaCcc72,2,mean)
    coefdatall.ch$lower3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 3] <- apply(betaCcc72,2,quantile,p=0.025)
    coefdatall.ch$upper3[coefdatall.ch$Parity == i & coefdatall.ch$coef == "c" & coefdatall.ch$cov %in% 1972:1982 & coefdatall.ch$qualf == 3] <- apply(betaCcc72,2,quantile,p=0.975)
  }
}

coefdatall.ch[coefdatall.ch$cov %in% c(1973:1981),c("lower3","upper3")] <- NA
coefdatall.ch$mean3a <- ifelse(coefdatall.ch$cov %in% c(1973:1981),NA,coefdatall.ch$mean3)


##Plot Figure 16
png(file="plots/fig16.png",width=20,height=10,units="cm",res=400)
ggplot(coefdatall.ch[coefdatall.ch$coef=="c",], aes(x=cov, y=mean, color = qualft)) +
  geom_point(shape=1) +
  geom_line(aes(linetype="Initial chosen model")) +
  geom_errorbar(aes(ymin=lower, ymax=upper), width=0.75,linetype=5) +
  geom_point(aes(x=cov,y=mean2a)) +
  geom_line(aes(x=cov,y=mean2,linetype="Variant 1"),size=0.6,show.legend = F) +
  geom_errorbar(aes(ymin=lower2, ymax=upper2), width=0.75,size=0.6) +
  geom_vline(data=data.frame(xint=1972,coef="c"), aes(xintercept=xint)) + 
  scale_linetype_manual(values=c("Initial chosen model" = 2, "Variant 1" = 1), guide=guide_legend(title="Model",nrow=1,order=2,title.position="top")) +
  labs(x = "Cohort (c)", y = expression(paste(beta["2,c"]^"j")), color = "Highest educational qualification (corresponds to j)") +
  scale_color_discrete(guide = guide_legend(reverse=FALSE,byrow=T,nrow=1,order=1,title.position="top")) +
  scale_x_continuous(breaks=c(seq(15,40,5),seq(1945,1990,5)), minor_breaks=c(setdiff(15:44,seq(15,40,5)),setdiff(1945:1992,seq(1945,1990,5))), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-0.4,4.1)) +
  theme_bw() + theme(legend.position = "bottom", text = element_text("Calibri")) + #,axis.text.x = element_text(angle = 90, vjust=0.45)) +
  facet_wrap(~Parity, scales="free",labeller=labeller(Parity=supp.labsp,coef=supp.labscov))
dev.off()


##Plot Figure 17
png(file="plots/fig17.png",width=20,height=10,units="cm",res=400)
ggplot(coefdatall.ch[coefdatall.ch$coef=="a",], aes(x=cov, y=mean2, color = qualft)) +
  geom_point(aes(x=cov,y=mean2a),shape=1) +
  geom_line(aes(x=cov,y=mean2,linetype="Variant 1")) +
  geom_errorbar(aes(ymin=lower2, ymax=upper2), width=0.75,linetype=5) +
  geom_point(aes(x=cov,y=mean3a)) +
  geom_line(aes(x=cov,y=mean3,linetype="Variant 2"),size=0.6,show.legend = F) +
  geom_errorbar(aes(ymin=lower3, ymax=upper3), width=0.75,size=0.6) +
  scale_linetype_manual(values=c("Variant 1" = 2, "Variant 2" = 1), guide=guide_legend(title="Model",order=2,title.position="top")) +
  labs(x = "Age (a)", y = expression(paste(beta["4,a"]^"j")), color = "Highest educational qualification (corresponds to j)") +
  scale_color_discrete(guide = guide_legend(reverse=FALSE,byrow=F,title.position="top",order=1),drop=F) +
  scale_x_continuous(breaks=c(seq(15,40,5),seq(1945,1990,5)), minor_breaks=c(setdiff(15:44,seq(15,40,5)),setdiff(1945:1992,seq(1945,1990,5))), expand=c(0.02,0.02)) +
  coord_cartesian(xlim=c(15,44),ylim=c(-4,1)) +
  theme_bw() + theme(legend.position = "bottom", text = element_text("Calibri")) +
  facet_wrap(~Parity, scales="free",labeller=labeller(Parity=supp.labsp,coef=supp.labscov))
dev.off()
