###Plot Figure 18

##Setup
supp.labsq2b <- c("< A Level","At least A Level")
names(supp.labsq2b) <- c(1,2)
supp.labsq3b <- c("< GCSE","GCSE/A Level","Degree")
names(supp.labsq3b) <- c(1,2,3)
supp.labsp <- c("Parity 1","Parity 2","Parity 3+")
names(supp.labsp) <- c(1,2,3)

files1 <- paste0("output/p1_TAQ_",
                 c(paste0(5,letters[1:4]),paste0(6,letters[1:8]),"6f.1","6f.2"),".RData",sep="")
files2 <- paste0("output/p2_TAQ_",
                 c(paste0(5,letters[1:4]),paste0(6,letters[1:8]),"5d.2"),".RData",sep="")
files3 <- paste0("output/p3_TA_",
                 c(paste0(1:6,"a"),"5a.2"),".RData",sep="")


##Extract parity 1 coefficients
coefp1dat <- data.frame(par=1,
                        mod=factor(rep(c("6f.1","6f.2"),each=2*Nab)),
                        qualf=rep(rep(c(1,2),each=Nab),2),
                        val=rep(12:42,4))
load(files1[13])
betaAb1_1 <- extract(stanout,pars="betaAb1",permuted=F)[,1,]
betaAb2_1 <- extract(stanout,pars="betaAb2",permuted=F)[,1,]
load(files1[14])
betaAb1_2 <- extract(stanout,pars="betaAb1",permuted=F)[,1,]
betaAb2_2 <- extract(stanout,pars="betaAb2",permuted=F)[,1,]

coefp1dat$mean <- c(apply(betaAb1_1,2,mean),apply(betaAb2_1,2,mean),
                    apply(betaAb1_2,2,mean),apply(betaAb2_2,2,mean))
coefp1dat$lower <- c(apply(betaAb1_1,2,quantile,p=0.025),apply(betaAb2_1,2,quantile,p=0.025),
                     apply(betaAb1_2,2,quantile,p=0.025),apply(betaAb2_2,2,quantile,p=0.025))
coefp1dat$upper <- c(apply(betaAb1_1,2,quantile,p=0.975),apply(betaAb2_1,2,quantile,p=0.975),
                     apply(betaAb1_2,2,quantile,p=0.975),apply(betaAb2_2,2,quantile,p=0.975))
coefp1dat$qualft <- factor(supp.labsq2b[coefp1dat$qualf],levels=c("< GCSE","< A Level","GCSE","GCSE/A Level","A Level","< Degree","At least A Level","Degree","All"))

coefp1dat2 <- coefp1dat[coefp1dat$mod=="6f.1",]
coefp1dat2 <- cbind(coefp1dat2,data.frame(mean2=coefp1dat$mean[coefp1dat$mod=="6f.2"],
                                          lower2=coefp1dat$lower[coefp1dat$mod=="6f.2"],
                                          upper2=coefp1dat$upper[coefp1dat$mod=="6f.2"]))

##Extract parity 2 coefficients
coefp2dat <- data.frame(par=2,
                        mod=factor(rep(c("5d","5d.2"),each=3*Nab)),
                        qualf=rep(rep(c(1,2,3),each=Nab),2),
                        val=rep(12:42,6))
load(files2[4])
betaAb1_1 <- extract(stanout,pars="betaAb1",permuted=F)[,1,]
betaAb2_1 <- extract(stanout,pars="betaAb2",permuted=F)[,1,]
betaAb3_1 <- extract(stanout,pars="betaAb3",permuted=F)[,1,]
load(files2[13])
betaAb1_2 <- extract(stanout,pars="betaAb1",permuted=F)[,1,]
betaAb2_2 <- extract(stanout,pars="betaAb2",permuted=F)[,1,]
betaAb3_2 <- extract(stanout,pars="betaAb3",permuted=F)[,1,]

coefp2dat$mean <- c(apply(betaAb1_1,2,mean),apply(betaAb2_1,2,mean),apply(betaAb3_1,2,mean),
                    apply(betaAb1_2,2,mean),apply(betaAb2_2,2,mean),apply(betaAb3_2,2,mean))
coefp2dat$lower <- c(apply(betaAb1_1,2,quantile,p=0.025),apply(betaAb2_1,2,quantile,p=0.025),apply(betaAb3_1,2,quantile,p=0.025),
                     apply(betaAb1_2,2,quantile,p=0.025),apply(betaAb2_2,2,quantile,p=0.025),apply(betaAb3_2,2,quantile,p=0.025))
coefp2dat$upper <- c(apply(betaAb1_1,2,quantile,p=0.975),apply(betaAb2_1,2,quantile,p=0.975),apply(betaAb3_1,2,quantile,p=0.975),
                     apply(betaAb1_2,2,quantile,p=0.975),apply(betaAb2_2,2,quantile,p=0.975),apply(betaAb3_2,2,quantile,p=0.975))
coefp2dat$qualft <- factor(supp.labsq3b[coefp2dat$qualf],levels=c("< GCSE","< A Level","GCSE","GCSE/A Level","A Level","< Degree","At least A Level","Degree","All"))

coefp2dat2 <- coefp2dat[coefp2dat$mod=="5d",]
coefp2dat2 <- cbind(coefp2dat2,data.frame(mean2=coefp2dat$mean[coefp2dat$mod=="5d.2"],
                                          lower2=coefp2dat$lower[coefp2dat$mod=="5d.2"],
                                          upper2=coefp2dat$upper[coefp2dat$mod=="5d.2"]))


##Extract parity 3+ coefficients
coefp3dat <- data.frame(par=3,
                        mod=rep(c("5a","5a.2"),each=31),
                        qualf=1,
                        val=rep(c(12:42),2))
load(files3[5])
betaAb1 <- extract(stanout,pars="betaAb",permuted=F)[,1,]
load(files3[7])
betaAb2 <- extract(stanout,pars="betaAb",permuted=F)[,1,]
coefp3dat$mean <- c(apply(betaAb1,2,mean),apply(betaAb2,2,mean))
coefp3dat$lower <- c(apply(betaAb1,2,quantile,p=0.025),apply(betaAb2,2,quantile,p=0.025))
coefp3dat$upper <- c(apply(betaAb1,2,quantile,p=0.975),apply(betaAb2,2,quantile,p=0.975))
coefp3dat$qualft <- factor("All",levels=c("< GCSE","< A Level","GCSE","GCSE/A Level","A Level","< Degree","At least A Level","Degree","All"))
coefp3dat2 <- coefp3dat[coefp3dat$mod=="5a",]
coefp3dat2 <- cbind(coefp3dat2,data.frame(mean2=coefp3dat$mean[coefp3dat$mod=="5a.2"],
                                          lower2=coefp3dat$lower[coefp3dat$mod=="5a.2"],
                                          upper2=coefp3dat$upper[coefp3dat$mod=="5a.2"]))


##Combine into one data frame
coefallpdat <- rbind(coefp3dat2,coefp1dat2,coefp2dat2)
coefallpdat$qualft <- factor(coefallpdat$qualft,levels=c("< A Level","At least A Level","< GCSE","GCSE/A Level","Degree","All"))


##Plot Figure 18
png(file="plots/fig18.png",width=20,height=10,units="cm",res=400)
ggplot(coefallpdat, aes(x=val, y=mean, col=qualft)) +
  geom_point(shape=1) +
  geom_line(aes(linetype="Initial chosen model/Variant 1")) +
  geom_errorbar(aes(ymin=lower, ymax=upper), width=0.75,linetype=5) +
  geom_point(aes(x=val,y=mean2)) +
  geom_line(aes(x=val,y=mean2,linetype="Variant 2"),size=0.6,show.legend = F) +
  geom_errorbar(aes(ymin=lower2, ymax=upper2), width=0.75,size=0.6) +
  scale_linetype_manual(values=c("Initial chosen model/Variant 1" = 2, "Variant 2" = 1), guide=guide_legend(title="Model",nrow=2,order=2,title.position="top")) +
  labs(x = expression(paste("Age at last birth event (",a[b],")")), y = expression(paste(beta["3,(q)"]^"a"["b"])), color = "Highest educational qualification (corresponding to q)") +
  scale_color_discrete(guide = guide_legend(reverse=FALSE,byrow=T,nrow=1,order=1,title.position="top")) +
  scale_x_continuous(breaks=seq(15,40,5), minor_breaks=setdiff(12:42,seq(15,40,5)), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(-10,10)) +
  theme_bw() + theme(legend.position = "bottom", text = element_text("Calibri")) +
  facet_wrap(~par,labeller=labeller(par=supp.labsp))
dev.off()
