###Plot Figure 2

##Setup
supp.labsq4 <- c("< GCSE","GCSE","A Level","Degree")
names(supp.labsq4) <- c(1,2,3,4)
supp.labsq2b <- c("< A Level","At least A Level")
names(supp.labsq2b) <- c(1,2)
supp.labsq3b <- c("< GCSE","GCSE/A Level","Degree")
names(supp.labsq3b) <- c(1,2,3)
supp.labsp <- c("Parity 0","Parity 1","Parity 2")
names(supp.labsp) <- c(0,1,2)

agerange <- 15:44
cohrange <- 1945:2003
stepdat <- data.frame(y=0.5+44:(2007-1982))
stepdat$x <- 2008-stepdat$y
stepdat <- rbind(stepdat,c(14.5,1982.5))


##Extract fitted probabilities from parity 0 chosen model
load("output/p0_QAC_5.2.RData")
theta <- extract(stanout,pars="theta",permuted=F)
thetam <- matrix(apply(theta[,1,],2,mean),ncol=4,byrow=F)
ACQdat0 <- expand.grid(age=agerange,coh=cohrange,qualf=1:4)
ACQdat0 <- cbind(ACQdat0,thetam=as.vector(thetam))
ACQdat0$qualft <- factor(supp.labsq4[ACQdat0$qualf],levels=supp.labsq4)
ACQdat0$par <- 0


##Extract fitted probabilities from parity 1 chosen model
load("output/p1_QAC_7.2.RData")
theta <- extract(stanout,pars="theta",permuted=F)
thetam <- matrix(apply(theta[,1,],2,mean),ncol=2,byrow=F)
ACQdat1 <- expand.grid(age=agerange,coh=cohrange,qualf=1:2)
ACQdat1 <- cbind(ACQdat1,thetam=as.vector(thetam))
ACQdat1$qualft <- factor(supp.labsq2b[ACQdat1$qualf],levels=supp.labsq2b)
ACQdat1$par <- 1


##Extract fitted probabilities from parity 2 chosen model
load("output/p2_QAC_5.2.RData")
theta <- extract(stanout,pars="theta",permuted=F)
thetam <- matrix(apply(theta[,1,],2,mean),ncol=3,byrow=F)
ACQdat2 <- expand.grid(age=agerange,coh=cohrange,qualf=1:3)
ACQdat2 <- cbind(ACQdat2,thetam=as.vector(thetam))
ACQdat2$qualft <- factor(supp.labsq3b[ACQdat2$qualf],levels=supp.labsq3b)
ACQdat2$par <- 2


##Combine into one data frame
ACQdat <- rbind(ACQdat0,ACQdat1,ACQdat2)
ACQdat$qualft <- factor(ACQdat$qualft,levels=c("< GCSE","< A Level","GCSE","GCSE/A Level","A Level","< Degree","At least A Level","Degree"))
ACQdat$par <- factor(ACQdat$par,levels=c(1,2,0))


##Plot Figure 2
png(file="plots/fig2.png",width=17.5,height=8,units="cm",res=400)
ggplot(ACQdat,aes(x=coh,y=age,fill=thetam)) +
  geom_raster(hjust=0.5,vjust=0.5) +
  labs(x = "Cohort", y = "Age", fill="Fitted\nprobability") +
  scale_fill_gradientn(colours=c("white",hcl.colors(10000,"viridis",rev=T),"black"), limits=c(0,1), guide = guide_colorbar(barheight = 12.5,barwidth=1,frame.colour="black",ticks.colour="black"), breaks = seq(0,1,0.1)) +
  scale_x_continuous(expand=c(0,0),breaks=seq(1950,2000,10), minor_breaks=setdiff(1945:2003,seq(1950,2010,10))) + 
  scale_y_continuous(expand=c(0,0),breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5))) +
  coord_cartesian(ylim=c(14.5,44.5),xlim=c(1944.3,2003.7)) +
  geom_step(data=stepdat, mapping=aes(x=x,y=y,fill=NULL),direction="vh",lwd=0.3) +
  theme_bw() + theme(strip.text = element_text(size=8), strip.text.x = element_text(margin = margin(0.1,0,0.1,0, "cm")), panel.grid.major = element_blank(),panel.grid.minor = element_blank(),axis.text.x = element_text(angle = 90, vjust=0.45),text = element_text("Calibri")) +
  facet_wrap(~par+qualft,nrow=2,labeller=labeller(par=supp.labsp),as.table = F)
dev.off()
