###Plot Figure 3

##Setup
supp.labsq2b <- c("< A Level","At least A Level")
names(supp.labsq2b) <- c(1,2)
supp.labsq3b <- c("< GCSE","GCSE/A Level","Degree")
names(supp.labsq3b) <- c(1,2,3)
supp.labsp <- c("Parity 1","Parity 2","Parity 3+")
names(supp.labsp) <- c(1,2,3)

agerange <- 15:44

#Step function
stepfunc <- function(start) {
  dat <- data.frame(y=start:11+0.5)
  dat$x <- seq(14,by=1,length=nrow(dat))+0.5
  dat
}


##Extract fitted probabilities from parity 1 chosen model
load("output/p1_TAQ_6f.2.RData")
Tprop1 <- extract(stanout,pars="Tprop1",permuted=F)
Tprop2 <- extract(stanout,pars="Tprop2",permuted=F)
Tpropm1 <- matrix(apply(Tprop1[,1,],2,mean),nrow=30,byrow=F)
Tpropm2 <- matrix(apply(Tprop2[,1,],2,mean),nrow=30,byrow=F)
Tpropdat1 <- data.frame(q=rep(1:2,each=30*11),age=rep(agerange,22),
                        gapc=rep(rep(1:11,each=30),2),
                        x=c(as.vector(Tpropm1),as.vector(Tpropm2)))
Tpropdat1$qualft <- factor(supp.labsq2b[Tpropdat1$q],levels=supp.labsq2b)
Tpropdat1$par <- 1


##Extract fitted probabilities from parity 2 chosen model
load("output/p2_TAQ_5d.2.RData")
Tprop1 <- extract(stanout,pars="Tprop1",permuted=F)
Tprop2 <- extract(stanout,pars="Tprop2",permuted=F)
Tprop3 <- extract(stanout,pars="Tprop3",permuted=F)
Tpropm1 <- matrix(apply(Tprop1[,1,],2,mean),nrow=30,byrow=F)
Tpropm2 <- matrix(apply(Tprop2[,1,],2,mean),nrow=30,byrow=F)
Tpropm3 <- matrix(apply(Tprop3[,1,],2,mean),nrow=30,byrow=F)
Tpropdat2 <- data.frame(q=rep(1:3,each=30*11),age=rep(agerange,33),gapc=rep(rep(1:11,each=30),3),
                        x=c(as.vector(Tpropm1),as.vector(Tpropm2),as.vector(Tpropm3)))
Tpropdat2$qualft <- factor(supp.labsq3b[Tpropdat2$q],levels=supp.labsq3b)
Tpropdat2$par <- 2


##Extract fitted probabilities from parity 3+ chosen model
load("output/p3_TA_5a.2.RData")
Tprop <- extract(stanout,pars="Tprop",permuted=F)
Tpropm <- matrix(apply(Tprop[,1,],2,mean),nrow=30,byrow=F)
Tpropdat3 <- data.frame(q=1,age=rep(agerange,11),gapc=rep(1:11,each=30),
                        x=as.vector(Tpropm))
Tpropdat3$qualft <- "All"
Tpropdat3$par <- 3


##Combine into one data frame
Tpropdat <- rbind(Tpropdat1,Tpropdat2,Tpropdat3)
Tpropdat$qualft <- factor(Tpropdat$qualft,levels=c("< GCSE","< A Level","GCSE","GCSE/A Level","A Level","< Degree","At least A Level","Degree","All"))


##Plot Figure 3
png(file="plots/fig3.png",width=15,height=8,units="cm",res=400)
ggplot(Tpropdat, aes(x=age,y=gapc,fill=x)) +
  geom_raster(hjust=0.5,vjust=0.5) +
  labs(x = "Age", y = "Time since last birth", fill="Fitted\nprobability") +
  scale_fill_gradientn(colours=c("white",hcl.colors(10000,"viridis",rev=T),"black"), limits=c(0,1), guide = guide_colorbar(barheight = 12.5, barwidth=1,frame.colour="black",ticks.colour="black"), breaks = seq(0,1,0.1)) +
  scale_y_continuous(expand=c(0,0),breaks=seq(1,11,2), minor_breaks=seq(2,10,2)) + 
  scale_x_continuous(expand=c(0,0),breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5))) +
  coord_cartesian(xlim=c(14.5,44.5),ylim=c(0.5,11.5)) +
  geom_step(data=stepfunc(3), mapping=aes(x=x,y=y),direction="hv") +
  theme_bw() + theme(strip.text = element_text(size=8), strip.text.x = element_text(margin = margin(0.1,0,0.1,0, "cm")),panel.grid.major = element_blank(),panel.grid.minor = element_blank(),text = element_text("Calibri")) +
  facet_wrap(~par+qualft,nrow=2,labeller=labeller(par=supp.labsp))
dev.off()
