###Plot Figure 4

##Setup
#Panel labels
supp.labsp <- paste0("Parity ",c(0,1,2,"3+"))
names(supp.labsp) <- c(0,1,2,3)
supp.labst <- c("1:0","9:1","2:1","1:1:","1:2","1:9","ONS data")
names(supp.labst) <- 1:7

#Construct separate data frames containing past and future age-cohort combinations
fdatACallp <- fdatACallf <- fdatACall
fdatACallp[which(fdatACallp$age+fdatACallp$coh>2018 & fdatACallp$type!=1),] <- NA
fdatACallf[which(fdatACallf$age+fdatACallf$coh<=2018 & fdatACallf$type!=1),] <- NA
fdatACallp[which(fdatACallp$age+fdatACallp$coh>2007 & fdatACallp$type==1),] <- NA
fdatACallf[which(fdatACallf$age+fdatACallf$coh<=2007 & fdatACallf$type==1),] <- NA


##Plot Figure 4
png(file="plots/fig4.png",width=15,height=20,units="cm",res=400)
ggplot(fdatACall, aes(x=age, y=mean, color=coh)) +
  geom_line(aes(x=fdatACallp$age, y=fdatACallp$mean, group=fdatACallp$coh), linewidth=0.3) +
  geom_line(aes(x=fdatACallf$age, y=fdatACallf$mean, group=fdatACallf$coh), linetype=2, linewidth=0.3) +
  labs(x = "Age", y = "Fitted probability/Observed rate", color="Cohort")+
  scale_color_gradientn(colours=hcl.colors(100,"viridis",rev=T),
                        guide = guide_colorbar(barheight=20,frame.colour="black",ticks.colour="black"),
                        breaks = seq(1945,2000,5), limits=c(1945,2003)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(0,0.35)) +
  theme_bw() + theme(legend.position="right",text = element_text("Calibri")) +
  facet_grid(type~parity,labeller=labeller(parity=supp.labsp,type=supp.labst))
dev.off()
