###Plot Figure 5

##Setup
#Panel labels
supp.labsq5 <- c("All","< GCSE","GCSE","A Level","Degree")
names(supp.labsq5) <- 0:4
supp.labst <- c("1:0","9:1","2:1","1:1","1:2","1:9","ONS data")
names(supp.labst) <- 1:7

#Extract parity 0 marginalised probabilities
fdatAC0 <- fdatACall[which(fdatACall$parity==0),1:7]
fdatAC0 <- data.frame(fdatAC0[,1:4],qualf=0,fdatAC0[,5:7])
names(fdatAC0)[6] <- "fit"

#Combine into one data frame
ACQdat02 <- rbind(ACQdat0,fdatAC0)

#Construct separate data frames containing past and future age-cohort combinations
ACQdat02p <- ACQdat02f <- ACQdat02
ACQdat02p[which(ACQdat02p$age+ACQdat02p$coh>2018&ACQdat02p$type!=1),] <- NA
ACQdat02f[which(ACQdat02f$age+ACQdat02f$coh<=2018&ACQdat02f$type!=1),] <- NA
ACQdat02p[which(ACQdat02p$age+ACQdat02p$coh>2007&ACQdat02p$type==1),] <- NA
ACQdat02f[which(ACQdat02f$age+ACQdat02f$coh<=2007&ACQdat02f$type==1),] <- NA


##Plot Figure 5
pind <- ACQdat02$type %in% c(1,4,6)
png(file="plots/fig5.png",width=25,height=15,units="cm",res=400)
ggplot(ACQdat02[pind,], aes(x=age, y=fit, color=coh)) +
  geom_line(aes(x=ACQdat02p$age[pind], y=ACQdat02p$fit[pind], group=ACQdat02p$coh[pind]), size=0.3) +
  geom_line(aes(x=ACQdat02f$age[pind], y=ACQdat02f$fit[pind], group=ACQdat02f$coh[pind]), linetype=2, size=0.3) +
  labs(x = "Age", y = "Fitted probability", color="Cohort")+
  scale_color_gradientn(colours=hcl.colors(100, "viridis",rev=T), guide = guide_colorbar(barheight = 20,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5), limits=c(1945,2003)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
  coord_cartesian(ylim=c(0,0.26)) +
  theme_bw() + theme(text = element_text("Calibri"),
                     axis.text=element_text(size=13),
                     axis.title=element_text(size=13),
                     strip.text=element_text(size=12),
                     legend.text=element_text(size=12),
                     legend.title=element_text(size=13)) +
  facet_grid(type~qualf,labeller=labeller(qualf=supp.labsq5,type=supp.labst))
dev.off()
