###Plot Figure 6

##Setup
#Panel labels
supp.labsq2b <- c("< A Level","At least A Level")
names(supp.labsq2b) <- c(1,2)
supp.labst <- c("1:0","9:1","2:1","1:1","1:2","1:9","ONS data")
names(supp.labst) <- 1:7


#Extract probabilities corresponding to an age at first birth of 19 years
ACTQdat1$aafb <- ACTQdat1$age - ACTQdat1$gapc
ACTQdat1_19 <- ACTQdat1[ACTQdat1$aafb==19|ACTQdat1$age>30&ACTQdat1$gapc==11,]

#Construct separate data frames containing past and future age-cohort combinations
ACTQdat1p_19 <- ACTQdat1f_19 <- ACTQdat1_19
ACTQdat1p_19[which(ACTQdat1p_19$age+ACTQdat1p_19$coh>2018&ACTQdat1p_19$type!=1),] <- NA
ACTQdat1f_19[which(ACTQdat1f_19$age+ACTQdat1f_19$coh<=2018&ACTQdat1f_19$type!=1),] <- NA
ACTQdat1p_19[which(ACTQdat1p_19$age+ACTQdat1p_19$coh>2007&ACTQdat1p_19$type==1),] <- NA
ACTQdat1f_19[which(ACTQdat1f_19$age+ACTQdat1f_19$coh<=2007&ACTQdat1f_19$type==1),] <- NA


##Plot Figure 6
pind <-  ACTQdat1_19$type %in% c(1,4) & ACTQdat1_19$coh %in% c(1960,1970,1980,1990,2000)
png(file="plots/fig6.png",width=25,height=18.5,units="cm",res=400)
print({ ggplot(ACTQdat1_19[pind,], aes(x=age, y=fit, color=coh)) +
    geom_line(aes(x=ACTQdat1p_19$age[pind],
                  y=ACTQdat1p_19$fit[pind],
                  group=ACTQdat1p_19$coh[pind]),
              size=0.8) +
    geom_line(aes(x=ACTQdat1f_19$age[pind],
                  y=ACTQdat1f_19$fit[pind],
                  group=ACTQdat1f_19$coh[pind]),
              linetype=2,size=0.8) +
    geom_line(aes(x=ACTQdat1p_19$age[pind],
                  y=ACTQdat1p_19$lower[pind],
                  group=ACTQdat1p_19$coh[pind]),
              size=0.3) +
    geom_line(aes(x=ACTQdat1f_19$age[pind],
                  y=ACTQdat1f_19$lower[pind],
                  group=ACTQdat1f_19$coh[pind]),
              linetype=2,size=0.3) +  
    geom_line(aes(x=ACTQdat1p_19$age[pind],
                  y=ACTQdat1p_19$upper[pind],
                  group=ACTQdat1p_19$coh[pind]),
              size=0.3) +
    geom_line(aes(x=ACTQdat1f_19$age[pind],
                  y=ACTQdat1f_19$upper[pind],
                  group=ACTQdat1f_19$coh[pind]),
              linetype=2,size=0.3) +
    geom_ribbon(aes(ymin=lower,ymax=upper,fill=coh),color=NA,alpha=0.15,show.legend=F) + 
    labs(x = "Age", y = "Probability", color="Cohort (c)")+
    scale_fill_gradientn(colours=hcl.colors(100, "viridis", rev=T), guide = guide_colorbar(barheight = 20,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5), limits=c(1945,2003)) +
    scale_color_gradientn(colours=hcl.colors(100, "viridis",rev=T), guide = guide_colorbar(barheight = 20,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5), limits=c(1945,2003)) +
    scale_x_continuous(limits=c(20,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.02,0.02)) +
    coord_cartesian(ylim=c(0,0.5)) +
    theme_bw() + theme(text = element_text("Calibri"),
                       axis.text=element_text(size=13),
                       axis.title=element_text(size=13),
                       strip.text=element_text(size=12),
                       legend.text=element_text(size=12),
                       legend.title=element_text(size=13)) +
    facet_grid(qualf+type~paste0(coh, " cohort"), labeller=labeller(qualf=supp.labsq2b,type=supp.labst)) })
dev.off()
