###Plot Figure 7

##Setup
#Panel labels
supp.labsp <- paste0("Parity ",c(0,1,2,"3+"))
names(supp.labsp) <- c(0,1,2,3)
supp.labst <- c("ONS data to 2018","ONS data to 2013")
names(supp.labst) <- 1:2

#Select cohorts to plot
cohs <- seq(1976,2000,6)

#Construct data frame containing intercepts for vertical lines
intdat <- rbind(data.frame(type=2,coh=cohs,xintercept=2013-cohs),
                data.frame(type=1,coh=cohs,xintercept=2018-cohs))

#Add shape column to fdatACall for plotting (un)observed rates
fdatACall$shape <- ifelse(fdatACall$type==1 | (fdatACall$type==2 & fdatACall$age+fdatACall$coh<=2013),1,2)
fdatACall$shape <- factor(c("Observed","Unobserved")[fdatACall$shape],levels=c("Observed","Unobserved"))

#Construct separate data frames containing past and future age-cohort combinations
fdatACallp <- fdatACallf <- fdatACall
fdatACallp[which(fdatACallp$age+fdatACallp$coh>2018 & fdatACall$type==1),] <- NA
fdatACallf[which(fdatACallf$age+fdatACallf$coh<=2018 & fdatACall$type==1),] <- NA
fdatACallp[which(fdatACallp$age+fdatACallp$coh>2013 & fdatACall$type==2),] <- NA
fdatACallf[which(fdatACallf$age+fdatACallf$coh<=2013 & fdatACall$type==2),] <- NA


##Plot Figure 7
pind <- fdatACall$p %in% c(0,1,2,3) & fdatACall$coh %in% cohs
png(file="plots/fig7.png",width=22.5,height=30,units="cm",res=400)
print({ ggplot(fdatACall[pind,], aes(x=age, y=mean, color=coh)) +
    geom_line(aes(x=fdatACallp$age[pind],
                  y=fdatACallp$mean[pind],
                  group=fdatACallp$coh[pind]),
              linewidth=0.3) +
    geom_line(aes(x=fdatACallf$age[pind],
                  y=fdatACallf$mean[pind],
                  group=fdatACallf$coh[pind]),
              linetype=2,linewidth=0.55) +
    geom_line(aes(x=fdatACallp$age[pind],
                  y=fdatACallp$lower[pind],
                  group=fdatACallp$coh[pind]),
              linewidth=0.3) +
    geom_line(aes(x=fdatACallf$age[pind],
                  y=fdatACallf$lower[pind],
                  group=fdatACallf$coh[pind]),
              linetype=2,linewidth=0.3) +  
    geom_line(aes(x=fdatACallp$age[pind],
                  y=fdatACallp$upper[pind],
                  group=fdatACallp$coh[pind]),
              linewidth=0.3) +
    geom_line(aes(x=fdatACallf$age[pind],
                  y=fdatACallf$upper[pind],
                  group=fdatACallf$coh[pind]),
              linetype=2,linewidth=0.3) +
    geom_vline(aes(xintercept=xintercept,color=coh),data=intdat) +
    geom_ribbon(aes(ymin=lower,ymax=upper,fill=coh),color=NA,alpha=0.15,show.legend=F) + 
    geom_point(aes(y=ONS,shape=shape)) +
    labs(x = "Age", y = "Probability", color="Cohort (c)")+
    scale_fill_gradientn(colours=hcl.colors(100,"viridis",rev=T), guide = guide_colorbar(order=2,barheight = 20,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5), limits=c(1945,2003)) +
    scale_color_gradientn(colours=hcl.colors(100, "viridis",rev=T), guide = guide_colorbar(order=2,barheight = 20,frame.colour="black",ticks.colour="black"), breaks = seq(1945,2000,5), limits=c(1945,2003)) +
    scale_shape_manual(values=c("Observed" = 1,"Unobserved"=19), guide=guide_legend(title="ONS data",order=1,nrow=2)) +
    scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.05,0.05)) +
    coord_cartesian(ylim=c(0,0.6)) + 
    theme_bw() + theme(text = element_text("Calibri"),
                       axis.text=element_text(size=11),
                       axis.title=element_text(size=13),
                       strip.text=element_text(size=12),
                       legend.text=element_text(size=12),
                       legend.title=element_text(size=13)) +
    facet_grid(parity+type~paste0(coh, " cohort"), labeller=labeller(parity=supp.labsp,type=supp.labst)) })
dev.off()
