###Plot Figure 8

##Setup
#Restrict NPP ASFRs to cohort range
npp2a <- npp2 %>% filter(coh %in% cohrange)

#Function to extract ASFR quantiles
asfrfunc <- function(asfrdat,type1,type2) {
  dat <- data.frame(type1=type1,
                    type2=type2,
                    age=rep(agerange,length(cohrange)),
                    coh=rep(cohrange,each=length(agerange)),
                    q5=apply(asfrdat,1,quantile,p=0.025),
                    q95=apply(asfrdat,1,quantile,p=0.975),
                    q50=apply(asfrdat,1,mean))
}

#Extract ASFR quantiles
asfrplot <- rbind(asfrfunc(asfrdat[[1]],"1:1","ONS data to 2018"),
                  asfrfunc(asfrdat[[2]],"1:9","ONS data to 2018"),
                  asfrfunc(asfrdat[[3]],"1:1","ONS data to 2013"),
                  data.frame(type1="ONS NPPs",type2="ONS data to 2018",
                             age=npp2a$age,coh=npp2a$coh,q5=NA,q95=NA,
                             q50=npp2a$x))
asfrplot$type1 <- factor(asfrplot$type1,levels=c("1:1","1:9","ONS NPPs"))
asfrplot$type2 <- factor(asfrplot$type2,levels=c("ONS data to 2013","ONS data to 2018"))

#Construct separate data frames containing past and future age-cohort combinations
asfrplotf <- asfrplot[(asfrplot$type2 %in% c("ONS data to 2018") &
                         asfrplot$age+asfrplot$coh>2018) |
                        (asfrplot$type2 =="ONS data to 2013" &
                           asfrplot$age+asfrplot$coh>2013),]
asfrplotp <- asfrplot[(asfrplot$type2 %in% c("ONS data to 2018") &
                         asfrplot$age+asfrplot$coh<=2018) |
                        (asfrplot$type2=="ONS data to 2013" &
                           asfrplot$age+asfrplot$coh<=2013),]

#Select cohorts to plot
cohs <- seq(1976,2000,6)

#Restrict to selected cohorts
ind <- which(asfrplot$coh %in% cohs)
indp <- which(asfrplotp$coh %in% cohs)
indf <- which(asfrplotf$coh %in% cohs)

#Create dataset with (un)observed rates to overlay 
ons2 <- ONS_rates_dat[[5]] %>% rename(age=Group.1,coh=Group.2) %>% filter(age %in% agerange)
onsdat <- rbind(data.frame(type1="1:1",type2= "ONS data to 2018",ons2,ind="Observed"),
                data.frame(type1="1:9",type2= "ONS data to 2018",ons2,ind="Observed"),
                data.frame(type1="ONS NPPs",type2="ONS data to 2018",ons2,ind="Observed"),
                data.frame(type1="1:1",type2= "ONS data to 2013",ons2,
                           ind=c("Unobserved","Observed")[as.numeric(ons2$age+ons2$coh<=2013)+1]))
onsdat$type1 <- factor(onsdat$type1,levels=c("1:1","1:9","ONS NPPs"))
onsdat$type2 <- factor(onsdat$type2,levels=c("ONS data to 2013","ONS data to 2018"))

#Construct data frame containing intercepts for vertical lines
intdat2 <- rbind(data.frame(type1="1:1",type2= "ONS data to 2018",coh=cohs,xintercept=2018-cohs),
                 data.frame(type1="1:9",type2= "ONS data to 2018",coh=cohs,xintercept=2018-cohs),
                 data.frame(type1="ONS NPPs",type2= "ONS data to 2018",coh=cohs,xintercept=2018-cohs),
                 data.frame(type1="1:1",type2= "ONS data to 2013",coh=cohs,xintercept=2013-cohs))
intdat2$type1 <- factor(intdat2$type1,levels=c("1:1","1:9","ONS NPPs"))
intdat2$type2 <- factor(intdat2$type2,levels=c("ONS data to 2013","ONS data to 2018"))


##Plot Figure 8
png(file="plots/fig8.png",width=25,height=18.5,units="cm",res=400)
ggplot(asfrplot[ind,], aes(x=age, y=q50, color=coh)) +
  geom_line(data=asfrplotp[indp,],
            aes(x=age,y=q50,group=coh),linewidth=0.3) +
  geom_line(data=asfrplotf[indf,],
            aes(x=age,y=q50,group=coh),linetype=2,linewidth=0.55) +
  geom_line(data=asfrplotp[indp,],
            aes(x=age,y=q5,group=coh),linewidth=0.3) +
  geom_line(data=asfrplotf[indf,],
            aes(x=age,y=q5,group=coh),linetype=2,linewidth=0.3) +
  geom_line(data=asfrplotp[indp,],
            aes(x=age,y=q95,group=coh),linewidth=0.3) +
  geom_line(data=asfrplotf[indf,],
            aes(x=age,y=q95,group=coh),linetype=2,linewidth=0.3) +
  geom_vline(aes(xintercept=xintercept,color=coh),data=intdat2) +
  geom_ribbon(aes(ymin=q5,ymax=q95,fill=coh),color=NA,alpha=0.15,show.legend=F) + 
  geom_point(data=onsdat %>% filter(coh %in% cohs),
             aes(y=x,shape=ind),size=1.2) +
  scale_shape_manual(values=c("Observed" = 1,"Unobserved"=19), guide=guide_legend(title="ONS data",order=1,nrow=2)) +
  labs(x = "Age", y = "Probability/ASFR", color="Cohort (c)",pch="ONS data")+
  scale_fill_gradientn(colours=hcl.colors(100, "viridis", rev=T), guide = guide_colorbar(barheight = 1,barwidth=27.5,frame.colour="black",ticks.colour="black"), breaks = seq(1950,2000,5), limits=c(1945,2003)) +
  scale_color_gradientn(colours=hcl.colors(100, "viridis", rev=T), guide = guide_colorbar(barheight = 1,barwidth=27.5,frame.colour="black",ticks.colour="black"), breaks = seq(1950,2000,5), limits=c(1945,2003)) +
  scale_x_continuous(limits=c(15,44), breaks=seq(15,44,5), minor_breaks=setdiff(15:44,seq(15,44,5)), expand=c(0.05,0.05)) +
  coord_cartesian(ylim=c(0,0.16)) +
  theme_bw() + theme(text = element_text("Calibri"),
                     legend.position="bottom",
                     axis.text=element_text(size=13),
                     axis.title=element_text(size=13),
                     strip.text=element_text(size=12),
                     legend.text=element_text(size=12),
                     legend.title=element_text(size=13)) +
  facet_grid(type1+type2~paste0(coh, " cohort"),drop=T)
dev.off()
