###Plot Figure 9

##Setup
#Compute observed CFR values
ONScfr <- apply(ONS_rates_mat[[5]],2,sum,na.rm=T)

#Compute projected CFR values from NPPs
npp2b <- rbind(ONS_rates_dat[[5]] %>% rename(age=Group.1,coh=Group.2),
              npp2 %>% select(age,coh,x)) %>% filter(coh %in% cohrange)
NPPcfr <- npp2b %>% group_by(coh) %>% summarise(cfr=sum(x))

#Function to extract CFR quantiles
cfrfunc <- function(cfrdat,type) {
  dat <- data.frame(type=type,
                    coh=cohrange,
                    obs=ONScfr*ifelse(cohrange<=1974,1,NA),
                    prn=NPPcfr$cfr*ifelse(cohrange<=1974,NA,1),
                    q5 =apply(cfrdat,1,quantile,p=0.05),
                    q25=apply(cfrdat,1,quantile,p=0.25),
                    q50=apply(cfrdat,1,quantile,p=0.50),
                    q75=apply(cfrdat,1,quantile,p=0.75),
                    q95=apply(cfrdat,1,quantile,p=0.95))
  dat
}

#Extract CFR quantiles
cfrplot <- rbind(cfrfunc(cfrdat[[1]],"1:1"),
                 cfrfunc(cfrdat[[2]],"1:9"))
cfrplot$type <- factor(cfrplot$type,levels=c("1:1","1:9"))


##Plot Figure 9
png(file="plots/fig9.png",width=15,height=12.5,units="cm",res=400)
ggplot(cfrplot,aes(x=coh)) +
  geom_ribbon_pattern(pattern="stripe",aes(ymin=q5,ymax=q95,pattern_angle="Proposed model",pattern_fill="Proposed model",pattern_color="Proposed model",fill="Proposed model",col=NULL),pattern_spacing=0.03,pattern_alpha=0.2,alpha=0.1,show.legend=T) +
  geom_line(aes(y=q50,col="1",linetype="1"),linewidth=0.4) +
  geom_line(aes(y=q25,col="1",linetype="2"),linewidth=0.4) +
  geom_line(aes(y=q75,col="1",linetype="2"),linewidth=0.4) +
  geom_line(aes(y=q5,col="1",linetype="3"),linewidth=0.4) +
  geom_line(aes(y=q95,col="1",linetype="3"),linewidth=0.4) +
  geom_line(aes(y=prn,linetype="1",col="ONS NPPs"),linewidth=0.6) +
  geom_point(aes(y=obs,shape="ONS\ndata"),show.legend = T,size=0.9) +
  geom_vline(aes(xintercept=1974),color="black") +
  scale_y_continuous(breaks=seq(0,3,0.2)) +
  scale_x_continuous(limits=c(1945,2003), breaks=seq(1945,2000,5), minor_breaks=setdiff(1945:2003,seq(1945,2000,5)), expand=c(0.02,0.02)) +
  guides(fill="none") +
  scale_pattern_angle_manual(values=c(45,135),guide="none") +
  scale_pattern_color_manual(values=c(NA,NA),guide="none") +
  scale_pattern_fill_manual(values=c(hcl.colors(10)[8],hcl.colors(10)[4]),guide="none") +
  scale_fill_manual(labels=c("Proposed model","ONS NPPs"),
                    values=c(hcl.colors(10)[8],1),
                    guide=guide_legend(title="Method",override.aes=list(pattern_color=c(hcl.colors(10)[8],NA),pattern_angle=c(45,0),pattern_fill=c(hcl.colors(10)[8],NA),linetype=c(0,0),fill=c(hcl.colors(10)[8],NA)))) +
  scale_color_manual(labels=c("Proposed model","ONS NPPs"),
                     values=c(hcl.colors(10)[8],1),
                     guide=guide_legend(override.aes = list(pattern_color=c(NA,NA),pattern_angle=c(45,0),pattern_fill=c(hcl.colors(10)[8],NA),linetype=c(1,1),pch=c(NA,NA),fill=c(hcl.colors(10)[8],NA)),
                                        title="Method",nrow=3,order=1,title.position="top")) +
  scale_shape_manual(values=19,guide=guide_legend(override.aes=list(pattern_color=NA,pattern_fill=NA,fill=NA))) +
  scale_linetype_manual(labels=c("Median/NPP Principal projection","50%","90%"),
                        values=c(1,5,2),
                        guide=guide_legend(override.aes=list(pattern_color=c(NA,NA,NA), pattern_fill=c(NA,NA,NA),linewidth=c(0.5,0.5,0.5),pch=c(NA,NA,NA),fill=c(NA,NA,NA)),
                                           title="Interval",nrow=3,order=2,title.position = "top")) +
  labs(x = "Cohort", y = "Completed family size",shape="") +
  facet_wrap(~type) + theme_bw() +
  theme(text = element_text("Calibri"), legend.position = "bottom",
        axis.text.x=element_text(angle=90,hjust=1,vjust=0.4))
dev.off()
