###Process HDI data

#Download HDI data from "https://hdr.undp.org/sites/default/files/2021-22_HDR/HDR21-22_Composite_indices_complete_time_series.csv".
#Saves HDI spreadsheet in "data" as "HDI_data.csv".
curl_download("https://hdr.undp.org/sites/default/files/2021-22_HDR/HDR21-22_Composite_indices_complete_time_series.csv",
              destfile = "data/HDI_data.csv")

#Read in HDI data 
HDIdat <- read.csv("data/HDI_data.csv")
HDIdat <- HDIdat[,c("country","hdi_2018")]
colnames(HDIdat) <- c("Country","HDI")
class(HDIdat$HDI) <- "numeric"
HDIdat$Country <- tolower(HDIdat$Country)
HDIdat <- HDIdat[which(!is.na(HDIdat$HDI)),]

#Create data frame with countries of birth present in the sample
HDIsurv <- data.frame(a_plbornc_all = unique(dat$a_plbornc_all[index]))

#Match numeric country variable to countries (make adjustments where there is no match in 'HDIdat')
HDIsurv %<>% mutate(Country =
                 case_when(a_plbornc_all == -8 ~ "united kingdom",
                           a_plbornc_all == 1  ~ "united kingdom",
                           a_plbornc_all == 5  ~ "ireland",
                           a_plbornc_all == 6  ~ "france",
                           a_plbornc_all == 7  ~ "germany",
                           a_plbornc_all == 8  ~ "italy",
                           a_plbornc_all == 9  ~ "spain",
                           a_plbornc_all == 10 ~ "poland",
                           a_plbornc_all == 11 ~ "cyprus",
                           a_plbornc_all == 12 ~ "turkey",
                           a_plbornc_all == 13 ~ "australia",
                           a_plbornc_all == 14 ~ "new zealand",
                           a_plbornc_all == 15 ~ "canada",
                           a_plbornc_all == 16 ~ "united states",
                           a_plbornc_all == 17 ~ "hong kong, china (sar)",
                           a_plbornc_all == 18 ~ "india",
                           a_plbornc_all == 19 ~ "pakistan",
                           a_plbornc_all == 20 ~ "bangladesh",
                           a_plbornc_all == 21 ~ "sri lanka",
                           a_plbornc_all == 22 ~ "kenya",
                           a_plbornc_all == 23 ~ "ghana",
                           a_plbornc_all == 24 ~ "nigeria",
                           a_plbornc_all == 25 ~ "uganda",
                           a_plbornc_all == 26 ~ "south africa",
                           a_plbornc_all == 27 ~ "jamaica",
                           a_plbornc_all == 101 ~ "yemen",
                           a_plbornc_all == 102 ~ "afghanistan",
                           a_plbornc_all == 103 ~ "east africa",
                           a_plbornc_all == 105 ~ "sub-saharan africa",
                           a_plbornc_all == 106 ~ "sub-saharan africa",
                           a_plbornc_all == 108 ~ "albania",
                           a_plbornc_all == 110 ~ "algeria",
                           a_plbornc_all == 112 ~ "angola",
                           a_plbornc_all == 113 ~ "latin america and the caribbean",
                           a_plbornc_all == 114 ~ "antigua and barbuda",
                           a_plbornc_all == 116 ~ "argentina",
                           a_plbornc_all == 118 ~ "armenia",
                           a_plbornc_all == 123 ~ "austria",
                           a_plbornc_all == 124 ~ "azerbaijan",
                           a_plbornc_all == 126 ~ "bahamas",
                           a_plbornc_all == 127 ~ "bahrain",
                           a_plbornc_all == 129 ~ "barbados",
                           a_plbornc_all == 131 ~ "belarus",
                           a_plbornc_all == 132 ~ "belgium",
                           a_plbornc_all == 134 ~ "benin",
                           a_plbornc_all == 135 ~ "very high human development",
                           a_plbornc_all == 140 ~ "bosnia and herzegovina",
                           a_plbornc_all == 141 ~ "botswana",
                           a_plbornc_all == 142 ~ "brazil",
                           a_plbornc_all == 146 ~ "brunei",
                           a_plbornc_all == 147 ~ "bulgaria",
                           a_plbornc_all == 148 ~ "burkina faso",
                           a_plbornc_all == 149 ~ "burundi",
                           a_plbornc_all == 151 ~ "cambodia",
                           a_plbornc_all == 152 ~ "cameroon",
                           a_plbornc_all == 154 ~ "cape verde",
                           a_plbornc_all == 160 ~ "channel islands",
                           a_plbornc_all == 161 ~ "chile",
                           a_plbornc_all == 165 ~ "colombia",
                           a_plbornc_all == 168 ~ "zaire",
                           a_plbornc_all == 174 ~ "cuba",
                           a_plbornc_all == 176 ~ "czechia",
                           a_plbornc_all == 177 ~ "czechia",
                           a_plbornc_all == 178 ~ "congo (democratic republic of the)",
                           a_plbornc_all == 179 ~ "denmark",
                           a_plbornc_all == 180 ~ "djibouti",
                           a_plbornc_all == 182 ~ "dominica",
                           a_plbornc_all == 183 ~ "dominican republic",
                           a_plbornc_all == 184 ~ "dubai",
                           a_plbornc_all == 187 ~ "ecuador",
                           a_plbornc_all == 188 ~ "egypt",
                           a_plbornc_all == 189 ~ "el salvador",
                           a_plbornc_all == 191 ~ "eritrea",
                           a_plbornc_all == 193 ~ "ethiopia",
                           a_plbornc_all == 195 ~ "very high human development",
                           a_plbornc_all == 197 ~ "fiji",
                           a_plbornc_all == 198 ~ "finland",
                           a_plbornc_all == 202 ~ "gabon",
                           a_plbornc_all == 203 ~ "gambia",
                           a_plbornc_all == 204 ~ "latin america and the caribbean",
                           a_plbornc_all == 205 ~ "georgia republic",
                           a_plbornc_all == 206 ~ "very high human development",
                           a_plbornc_all == 209 ~ "greece",
                           a_plbornc_all == 211 ~ "grenada",
                           a_plbornc_all == 214 ~ "very high human development",
                           a_plbornc_all == 215 ~ "guinea",
                           a_plbornc_all == 216 ~ "guinea-bissau",
                           a_plbornc_all == 217 ~ "guyana",
                           a_plbornc_all == 218 ~ "haiti",
                           a_plbornc_all == 222 ~ "honduras",
                           a_plbornc_all == 223 ~ "hungary",
                           a_plbornc_all == 228 ~ "indonesia",
                           a_plbornc_all == 230 ~ "iran (islamic republic of)",
                           a_plbornc_all == 231 ~ "iraq",
                           a_plbornc_all == 233 ~ "very high human development",
                           a_plbornc_all == 234 ~ "israel",
                           a_plbornc_all == 235 ~ "côte d'ivoire",
                           a_plbornc_all == 236 ~ "japan",
                           a_plbornc_all == 238 ~ "very high human development",
                           a_plbornc_all == 241 ~ "jordan",
                           a_plbornc_all == 242 ~ "south asia",
                           a_plbornc_all == 243 ~ "kazakhstan",
                           a_plbornc_all == 247 ~ "korea (republic of)",
                           a_plbornc_all == 248 ~ "europe and central asia",
                           a_plbornc_all == 249 ~ "kuwait",
                           a_plbornc_all == 251 ~ "lao people's democratic republic",
                           a_plbornc_all == 252 ~ "latvia",
                           a_plbornc_all == 253 ~ "lebanon",
                           a_plbornc_all == 255 ~ "liberia",
                           a_plbornc_all == 256 ~ "libya",
                           a_plbornc_all == 259 ~ "lithuania",
                           a_plbornc_all == 264 ~ "madagascar",
                           a_plbornc_all == 265 ~ "malawi",
                           a_plbornc_all == 266 ~ "malaysia",
                           a_plbornc_all == 269 ~ "malta",
                           a_plbornc_all == 271 ~ "latin america and the caribbean",
                           a_plbornc_all == 273 ~ "mauritius",
                           a_plbornc_all == 275 ~ "mexico",
                           a_plbornc_all == 276 ~ "arab states",
                           a_plbornc_all == 278 ~ "moldova (republic of)",
                           a_plbornc_all == 282 ~ "latin america and the caribbean",
                           a_plbornc_all == 283 ~ "morocco",
                           a_plbornc_all == 284 ~ "mozambique",
                           a_plbornc_all == 285 ~ "myanmar",
                           a_plbornc_all == 286 ~ "namibia",
                           a_plbornc_all == 288 ~ "nepal",
                           a_plbornc_all == 296 ~ "norway",
                           a_plbornc_all == 301 ~ "palestine, state of",
                           a_plbornc_all == 303 ~ "panama",
                           a_plbornc_all == 305 ~ "papua new guinea",
                           a_plbornc_all == 306 ~ "paraguay",
                           a_plbornc_all == 307 ~ "peru",
                           a_plbornc_all == 309 ~ "philippines",
                           a_plbornc_all == 312 ~ "portugal",
                           a_plbornc_all == 314 ~ "qatar",
                           a_plbornc_all == 318 ~ "romania",
                           a_plbornc_all == 320 ~ "russian federation",
                           a_plbornc_all == 321 ~ "rwanda",
                           a_plbornc_all == 325 ~ "saudi arabia",
                           a_plbornc_all == 326 ~ "senegal",
                           a_plbornc_all == 327 ~ "serbia",
                           a_plbornc_all == 328 ~ "seychelles",
                           a_plbornc_all == 330 ~ "sierra leone",
                           a_plbornc_all == 331 ~ "singapore",
                           a_plbornc_all == 332 ~ "slovakia",
                           a_plbornc_all == 333 ~ "slovenia",
                           a_plbornc_all == 335 ~ "sub-saharan africa",
                           a_plbornc_all == 336 ~ "latin america and the caribbean",
                           a_plbornc_all == 337 ~ "saint kitts and nevis",
                           a_plbornc_all == 338 ~ "st helena",
                           a_plbornc_all == 339 ~ "saint lucia",
                           a_plbornc_all == 341 ~ "saint vincent and the grenadines",
                           a_plbornc_all == 343 ~ "sudan",
                           a_plbornc_all == 345 ~ "swaziland",
                           a_plbornc_all == 346 ~ "sweden",
                           a_plbornc_all == 347 ~ "switzerland",
                           a_plbornc_all == 348 ~ "syrian arab republic",
                           a_plbornc_all == 349 ~ "east asia and the pacific",
                           a_plbornc_all == 351 ~ "tanzania (united republic of)",
                           a_plbornc_all == 352 ~ "thailand",
                           a_plbornc_all == 353 ~ "netherlands",
                           a_plbornc_all == 355 ~ "togo",
                           a_plbornc_all == 359 ~ "trinidad and tobago",
                           a_plbornc_all == 361 ~ "tunisia",
                           a_plbornc_all == 364 ~ "east asia and the pacific",
                           a_plbornc_all == 365 ~ "ukraine",
                           a_plbornc_all == 367 ~ "russian federation",
                           a_plbornc_all == 368 ~ "united arab emirates",
                           a_plbornc_all == 370 ~ "uruguay",
                           a_plbornc_all == 376 ~ "venezuela (bolivarian republic of)",
                           a_plbornc_all == 377 ~ "east asia and the pacific",
                           a_plbornc_all == 382 ~ "latin america and the caribbean",
                           a_plbornc_all == 384 ~ "yemen",
                           a_plbornc_all == 385 ~ "yugoslavia",
                           a_plbornc_all == 386 ~ "zambia",
                           a_plbornc_all == 387 ~ "zimbabwe",
                           a_plbornc_all == 388 ~ "latin america and the caribbean",
                           a_plbornc_all == 997 ~ "world"))

#Merge HDIsurv with HDIdat to add in HDI values
HDIsurv %<>% left_join(HDIdat)

#Check there are no missing HDI values
if(sum(is.na(HDIsurv$HDI)) > 0) stop("Need to recode some countries")

#Code the following variables using the classification on p295 of the 2019 Human Development Report
#HDIc5: 1 = low, 2 = medium, 3 = high, 4 = very high, 5 = UK-born
#HDIc4a: 1 = low, 2 = medium, 3 = high, 4 = very high/UK-born
#HDIc4b: 1 = low, 2 = medium, 3 = high/very high, 4 = UK-born
#HDIc4c: 1 = low, 2 = medium/high, 3 = very high, 4 = UK-born
#HDIc4d: 1 = low/medium, 2 = high, 3 = very high, 4 = UK-born
#HDIc3a: 1 = low, 2 = medium, 3 = high/very high/UK-born
#HDIc3b: 1 = low, 2 = medium/high, 3 = very high/UK-born
#HDIc3c: 1 = low, 2 = medium/high/very high, 3 = UK-born
#HDIc3d: 1 = low/medium, 2 = high, 3 = very high/UK-born
#HDIc3e: 1 = low/medium, 2 = high/very high, 3 = UK-born
#HDIc3f: 1 = low/medium/high, 2 = very high, 3 = UK-born
#HDIc2a: 1 = low, 2 = medium/high/very high/UK-born
#HDIc2b: 1 = low/medium, 2 = high/very high/UK-born
#HDIc2c: 1 = low/medium/high, 2 = very high/UK-born
#HDIc2d: 1 = low/medium/high/very high, 2 = UK-born
HDIsurv$HDIr <- round(HDIsurv$HDI,3)
HDIsurv$HDIc5 <- ifelse(HDIsurv$Country == "united kingdom", 5,
                       ifelse(HDIsurv$HDIr < 0.550, 1,
                              ifelse(HDIsurv$HDIr >= 0.550 & HDIsurv$HDIr < 0.700, 2, 
                                     ifelse(HDIsurv$HDIr >= 0.700 & HDIsurv$HDIr < 0.800, 3, 4))))
HDIsurv$HDIc4a <- ifelse(HDIsurv$HDIc5 > 4, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc4b <- ifelse(HDIsurv$HDIc5 > 3, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc4c <- ifelse(HDIsurv$HDIc5 > 2, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc4d <- ifelse(HDIsurv$HDIc5 > 1, HDIsurv$HDIc5-1, HDIsurv$HDIc5)
HDIsurv$HDIc3a <- ifelse(HDIsurv$HDIc5 > 3, 3, HDIsurv$HDIc5)
HDIsurv$HDIc3b <- ifelse(HDIsurv$HDIc5 > 3, 3, ifelse(HDIsurv$HDIc5 > 2, 2, HDIsurv$HDIc5))
HDIsurv$HDIc3c <- ifelse(HDIsurv$HDIc5 > 4, 3, ifelse(HDIsurv$HDIc5 > 2, 2, HDIsurv$HDIc5))
HDIsurv$HDIc3d <- ifelse(HDIsurv$HDIc5 > 3, 3, ifelse(HDIsurv$HDIc5 > 1, HDIsurv$HDIc5-1, HDIsurv$HDIc5))
HDIsurv$HDIc3e <- ifelse(HDIsurv$HDIc5 > 4, 3, ifelse(HDIsurv$HDIc5 > 2, 2, 1))
HDIsurv$HDIc3f <- ifelse(HDIsurv$HDIc5 > 3, HDIsurv$HDIc5-2, 1)
HDIsurv$HDIc2a <- ifelse(HDIsurv$HDIc5 > 1, 2, 1)
HDIsurv$HDIc2b <- ifelse(HDIsurv$HDIc5 > 2, 2, 1)
HDIsurv$HDIc2c <- ifelse(HDIsurv$HDIc5 > 3, 2, 1)
HDIsurv$HDIc2d <- ifelse(HDIsurv$HDIc5 > 4, 2, 1)
