###Process backtesting model outputs

##Setup
#Load ONS data
load("data/ONS2018_allc.RData")

#Source functions
source("r/integrated_functions.r")

#Indicate single integrated model type fitted with back = TRUE and back = FALSE to each parity
mod <- c("9:1","2:1","1:1","1:2","1:9")[3]
parity <- rep(0:3,2)
type <- rep(1:2, each=4)

#ONS data setup
data4 <- list()
for (i in 1:4) {
  data4[[i]] <- data.frame(age=ONS_births_dat[[i]]$Group.1,coh=ONS_births_dat[[i]]$Group.2,N=ONS_expos_dat[[i]]$x,n=ONS_births_dat[[i]]$x,ONS=ONS_rates_dat[[i]]$x)
  data4[[i]] <- data4[[i]][which(data4[[i]]$N>0 & data4[[i]]$n>=0 & data4[[i]]$n <= data4[[i]]$N & data4[[i]]$age %in% c(15:44)),]
}
data4l <- rbind(data.frame(parity=0,data4[[1]]),
                data.frame(parity=1,data4[[2]]),
                data.frame(parity=2,data4[[3]]),
                data.frame(parity=3,data4[[4]]))

#Specify file names
files <- c(paste0("output/p",c(0,1,2,3),"_",gsub(":","_",mod),".RData"),
           paste0("output/p",c(0,1,2,3),"_",gsub(":","_",mod),"_2013.RData"))

#Prepare objects to store results
results <- list()
results$probdat <- results$psurvf <- results$psurvfm <- results$psurvfl <- results$psurvfu <- list()

##Extract results from fitted models
for (n in 1:length(files)) {
  print(n)
  p <- parity[n]
  source(paste0("r/p",p,"_setup.r"))
  ind <- -c(1:64)
  load(files[n])
  source(paste0("r/p",p,"clean.r"))
}


##Combine results
#Marginalized
fdatACall <- data.frame(type=rep(1:2,each=4*length(agerange)*length(cohrange)),
                        parity=rep(parity,each=length(agerange)*length(cohrange)),
                        age=rep(rep(agerange,length(cohrange)),length(files)),
                        coh=rep(rep(cohrange,each=length(agerange)),length(files)),
                        mean=unlist(results$psurvfm),
                        lower=unlist(results$psurvfl),
                        upper=unlist(results$psurvfu))
fdatACall <- left_join(fdatACall,data4l[,c("parity","age","coh","ONS")],by=c("parity","age","coh"))
fdatACall$type <- factor(fdatACall$type,levels=1:2)


##Save marginalised probability samples for Step 9 (aggregate forecasts)
psurvf <- list()
n <- which(type==2)[1]
for (i in 1:1000) {
  psurvf[[i]] <- data.frame(expand.grid(age=15:44,coh=1945:2003),
                            p1=results$psurvf[[n]][i,],
                            p2=results$psurvf[[n+1]][i,],
                            p3=results$psurvf[[n+2]][i,],
                            p4=results$psurvf[[n+3]][i,])
}
save(psurvf,file=paste0("output/ACprob_",gsub(":","_",mod),"_2013.RData"))
