###Process integrated model outputs

##Setup
#Load ONS data
load("data/ONS2018_allc.RData")

#Source functions
source("r/integrated_functions.r")

#Indicate models fitted
indmod <- expand.grid(mod=c("9:1","2:1","1:1","1:2","1:9","1:0"),parity=0:3)
indTF <- c(T, T, T, T, T, T)  # change T to F depending on models fitted (assumes same models fitted for each parity)
indmod$fit <- rep(indTF,4)
if (all(!indTF)) stop("Analysis requires at least one model type to have been fitted to each parity")
if (indTF[6] & sum(indTF[1:5])==0) stop("Analysis of UKHLS-only model requires at least one integrated model to have been fitted")
indmod$type <- rep(c(2:6,1),4)
indfit <- which(indmod$fit)
parity <- indmod$parity[indfit]
mod <- indmod$mod[indfit]
mod2 <- indmod$mod[which(indTF)]
type <- indmod$type[which(indTF)]

#ONS data setup
data4 <- list()
for (i in 1:4) {
  data4[[i]] <- data.frame(age=ONS_births_dat[[i]]$Group.1,coh=ONS_births_dat[[i]]$Group.2,N=ONS_expos_dat[[i]]$x,n=ONS_births_dat[[i]]$x,ONS=ONS_rates_dat[[i]]$x)
  data4[[i]] <- data4[[i]][which(data4[[i]]$N>0 & data4[[i]]$n>=0 & data4[[i]]$n <= data4[[i]]$N & data4[[i]]$age %in% c(15:44)),]
}
data4l <- rbind(data.frame(parity=0,data4[[1]]),
                data.frame(parity=1,data4[[2]]),
                data.frame(parity=2,data4[[3]]),
                data.frame(parity=3,data4[[4]]))

#Specify file names
files <- c(paste0("output/p0_",c("9_1","2_1","1_1","1_2","1_9","1_0"),".RData"),
           paste0("output/p1_",c("9_1","2_1","1_1","1_2","1_9","1_0"),".RData"),
           paste0("output/p2_",c("9_1","2_1","1_1","1_2","1_9","1_0"),".RData"),
           paste0("output/p3_",c("9_1","2_1","1_1","1_2","1_9","1_0"),".RData"))[indfit]

#Prepare objects to store results
results <- list()
results$probdat <- results$psurvf <- results$psurvfm <- results$psurvfl <- results$psurvfu <- list()


##Extract results from fitted models
for (n in 1:length(files)) {
  print(n)
  p <- parity[n]
  m <- mod[n]
  source(paste0("r/p",p,"_setup.r"))
  ind <- -c(1:64)
  load(files[n])
  if (mod[n] != "1:0") source(paste0("r/p",p,"clean.r"))
  if (mod[n] == "1:0") source(paste0("r/p",p,"cleanUKHLS.r"))
}


##Combine results
#Marginalized
fdatACall <- data.frame(type=rep(rep(type,4),each=length(agerange)*length(cohrange)),
                        parity=rep(parity,each=length(agerange)*length(cohrange)),
                        age=rep(rep(agerange,length(cohrange)),length(files)),
                        coh=rep(rep(cohrange,each=length(agerange)),length(files)),
                        mean=unlist(results$psurvfm),
                        lower=unlist(results$psurvfl),
                        upper=unlist(results$psurvfu))
fdatACall <- left_join(fdatACall,data4l[,c("parity","age","coh","ONS")],by=c("parity","age","coh"))
fdatACall <- rbind(fdatACall,data.frame(data4l[,c("parity","age","coh")],mean=data4l$ONS,lower=NA,upper=NA,ONS=NA,type=7))
fdatACall$type <- factor(fdatACall$type,levels=1:7)

#Unmarginalized
ACQdat0 <- data.frame(type=rep(type,each=4*length(agerange)*length(cohrange)),
                      Reduce(rbind,results$probdat[which(parity==0)]))
ACTQdat1 <- data.frame(type=rep(type,each=22*length(agerange)*length(cohrange)),
                       Reduce(rbind,results$probdat[which(parity==1)]))
ACTQdat2 <- data.frame(type=rep(type,each=33*length(agerange)*length(cohrange)),
                       Reduce(rbind,results$probdat[which(parity==2)]))
ACTdat3 <- data.frame(type=rep(type,each=11*length(agerange)*length(cohrange)),
                      Reduce(rbind,results$probdat[which(parity==3)]))


##Save marginalised probability samples for Step 9 (aggregate forecasts)
nmod <- length(mod2)
psurvf <- list()
for (n in 1:nmod) {
  for (i in 1:1000) {
    psurvf[[i]] <- data.frame(expand.grid(age=15:44,coh=1945:2003),
                              p1=results$psurvf[[n]][i,],
                              p2=results$psurvf[[n+nmod]][i,],
                              p3=results$psurvf[[n+2*nmod]][i,],
                              p4=results$psurvf[[n+3*nmod]][i,])
  }
  save(psurvf,file=paste0("output/ACprob_",gsub(":","_",mod2[n]),".RData"))
}
