data {
  int Nac;
  int Nc72;
  int Na;
  int Nobs;
  int y[Nac,4];
  int ccind72[Nac];
  vector[Nac] cc72;
  int aind[Nac];
  vector[Nac] a;
  int yind[Nobs];
  vector[Nac] wt;
}

parameters {
  vector[3] beta0;
  vector[Nc72-1] betaC1raw;
  vector[Nc72-1] betaC2raw;
  vector[Nc72-1] betaC3raw;
  vector[3] betaC;
  vector[Na-1] betaA3raw;
  vector[2] betaA;
}

transformed parameters {
  simplex[4] theta[Nac];
  matrix[Nac,4] Yhat;
  vector[Nc72] betaC1;
  vector[Nc72] betaC2;
  vector[Nc72] betaC3;
  vector[Na] betaA3;
  betaC1[1] = 0;
  betaC2[1] = 0;
  betaC3[1] = 0;
  betaA3[1] = 0;
  betaC1[2:Nc72] = betaC1raw;
  betaC2[2:Nc72] = betaC2raw;
  betaC3[2:Nc72] = betaC3raw;
  betaA3[2:Na] = betaA3raw;
  Yhat[,1] = rep_vector(0,Nac);
  Yhat[,2] = beta0[1] + betaC1[ccind72] + betaC[1]*cc72 + betaA[1]*a;
  Yhat[,3] = beta0[2] + betaC2[ccind72] + betaC[2]*cc72 + betaA[2]*a;
  Yhat[,4] = beta0[3] + betaC3[ccind72] + betaC[3]*cc72 + betaA3[aind];
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC ~ normal(0,10);
  betaC1raw ~ normal(0,10);
  betaC2raw ~ normal(0,10);
  betaC3raw ~ normal(0,10);
  betaA3raw ~ normal(0,10);
  betaA ~ normal(0,10);
  for (i in yind) {
    target += wt[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
}
