data {
  int Nac;
  int Nc82;
  int Na;
  int Nobs;
  int y[Nac,4];
  int ccind82[Nac];
  vector[Nac] cc;
  int aind[Nac];
  vector[Nac] a;
  int yind[Nobs];
  vector[Nac] wt;
}

parameters {
  vector[3] beta0;
  vector[Nc82-1] betaC1raw;
  vector[Nc82-1] betaC2raw;
  vector[Nc82-1] betaC3raw;
  vector[Na-1] betaA2raw;
  vector[Na-1] betaA3raw;
  real betaA;
}

transformed parameters {
  simplex[4] theta[Nac];
  matrix[Nac,4] Yhat;
  vector[Nc82] betaC1;
  vector[Nc82] betaC2;
  vector[Nc82] betaC3;
  vector[Na] betaA2;
  vector[Na] betaA3;
  betaC1[1] = 0;
  betaC2[1] = 0;
  betaC3[1] = 0;
  betaA2[1] = 0;
  betaA3[1] = 0;
  betaC1[2:Nc82] = betaC1raw;
  betaC2[2:Nc82] = betaC2raw;
  betaC3[2:Nc82] = betaC3raw;
  betaA2[2:Na] = betaA2raw;
  betaA3[2:Na] = betaA3raw;
  Yhat[,1] = rep_vector(0,Nac);
  Yhat[,2] = beta0[1] + betaC1[ccind82] + betaA*a;
  Yhat[,3] = beta0[2] + betaC2[ccind82] + betaA2[aind];
  Yhat[,4] = beta0[3] + betaC3[ccind82] + betaA3[aind];
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC1raw ~ normal(0,10);
  betaC2raw ~ normal(0,10);
  betaC3raw ~ normal(0,10);
  betaA2raw ~ normal(0,10);
  betaA3raw ~ normal(0,10);
  betaA ~ normal(0,10);
  for (i in yind) {
    target += wt[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
}
