data {
  int Nac;
  int Nc72;
  int Na;
  int Nc;
  int Nobs;
  int y[Nac,2];
  int ccind72[Nac];
  vector[Nac] cc;
  vector[Nac] cc72;
  int aind[Nac];
  vector[Nac] a;
  int yind[Nobs];
  vector[Nac] wt;
}

parameters {
  real beta0;
  real betaC;
}

transformed parameters {
  simplex[2] theta[Nac];
  matrix[Nac,2] Yhat;
  Yhat[,1] = rep_vector(0,Nac);
  Yhat[,2] = beta0 + betaC*cc;
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC ~ normal(0,10);
  for (i in yind) {
    target += wt[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
}
