data {
  int Nac;
  int Nc82;
  int Na;
  int Nobs;
  int y[Nac,2];
  int ccind[Nac];
  int ccind82[Nac];
  vector[Nac] cc;
  int aind[Nac];
  vector[Nac] a;
  int yind[Nobs];
  vector[Nac] wt;
}

parameters {
  real beta0;
  vector[Nc82-1] betaC1raw;
}

transformed parameters {
  simplex[2] theta[Nac];
  matrix[Nac,2] Yhat;
  vector[Nc82] betaC1;
  betaC1[1] = 0;
  betaC1[2:Nc82] = betaC1raw;
  Yhat[,1] = rep_vector(0,Nac);
  Yhat[,2] = beta0 + betaC1[ccind82];
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC1raw ~ normal(0,10);
  for (i in yind) {
    target += wt[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
}
