data {
  int Nac;
  int Nc72;
  int Na;
  int Nobs;
  int y[Nac,2];
  int ccind72[Nac];
  vector[Nac] cc72;
  int aind[Nac];
  vector[Nac] a;
  int yind[Nobs];
  vector[Nac] wt;
}

parameters {
  real beta0;
  vector[Nc72-1] betaC1raw;
  real betaC;
  vector[Na-1] betaA1raw;
  real<lower=0> sigmaA1;
}

transformed parameters {
  simplex[2] theta[Nac];
  matrix[Nac,2] Yhat;
  vector[Nc72] betaC1;
  vector[Na] betaA1;
  betaC1[1] = 0;
  betaA1[Na] = 0;
  betaC1[2:Nc72] = betaC1raw;
  betaA1[1:(Na-1)] = betaA1raw;
  Yhat[,1] = rep_vector(0,Nac);
  Yhat[,2] = beta0 + betaC1[ccind72] + betaC*cc72 + betaA1[aind];
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC1raw ~ normal(0,10);
  betaC ~ normal(0,10);
  betaA1raw[1] ~ normal(0,10);
  for (i in 2:(Na-1)) {
    betaA1raw[i] ~ normal(betaA1raw[i-1],sigmaA1);
  }
  sigmaA1 ~ normal(0,0.01);
  for (i in yind) {
    target += wt[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
}
