data {
  int Na;
  int Nab;
  int y1[Na,11];
  int y2[Na,11];
  vector[Na] a;
  int ab[Na,10];
  vector[Na] wt1;
  vector[Na] wt2;
}

parameters {
  vector[10] betaA;
  vector[Nab] betaAb1;
  vector[Nab] betaAb2;
}

transformed parameters {
  simplex[3] theta3_1;
  simplex[4] theta4_1;
  simplex[5] theta5_1;
  simplex[6] theta6_1;
  simplex[7] theta7_1;
  simplex[8] theta8_1;
  simplex[9] theta9_1;
  simplex[10] theta10_1;
  simplex[11] theta11_1[Na-8];
  simplex[3] theta3_2;
  simplex[4] theta4_2;
  simplex[5] theta5_2;
  simplex[6] theta6_2;
  simplex[7] theta7_2;
  simplex[8] theta8_2;
  simplex[9] theta9_2;
  simplex[10] theta10_2;
  simplex[11] theta11_2[Na-8];
  matrix[Na,11] Yhat_1;
  matrix[Na,11] Yhat_2;
  Yhat_1[,1] = rep_vector(0,Na);
  Yhat_2[,1] = rep_vector(0,Na);
  for (i in 2:11) {
    Yhat_1[,i] = betaA[i-1]*a + betaAb1[ab[,(i-1)]];
    Yhat_2[,i] = betaA[i-1]*a + betaAb2[ab[,(i-1)]];
  }
  theta3_1 = softmax(to_vector(Yhat_1[1,1:3]));
  theta4_1 = softmax(to_vector(Yhat_1[2,1:4]));
  theta5_1 = softmax(to_vector(Yhat_1[3,1:5]));
  theta6_1 = softmax(to_vector(Yhat_1[4,1:6]));
  theta7_1 = softmax(to_vector(Yhat_1[5,1:7]));
  theta8_1 = softmax(to_vector(Yhat_1[6,1:8]));
  theta9_1 = softmax(to_vector(Yhat_1[7,1:9]));
  theta10_1 = softmax(to_vector(Yhat_1[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_1[i] = softmax(to_vector(Yhat_1[(i+8),]));
  }
  theta3_2 = softmax(to_vector(Yhat_2[1,1:3]));
  theta4_2 = softmax(to_vector(Yhat_2[2,1:4]));
  theta5_2 = softmax(to_vector(Yhat_2[3,1:5]));
  theta6_2 = softmax(to_vector(Yhat_2[4,1:6]));
  theta7_2 = softmax(to_vector(Yhat_2[5,1:7]));
  theta8_2 = softmax(to_vector(Yhat_2[6,1:8]));
  theta9_2 = softmax(to_vector(Yhat_2[7,1:9]));
  theta10_2 = softmax(to_vector(Yhat_2[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_2[i] = softmax(to_vector(Yhat_2[(i+8),]));
  }
}

model {
  betaA ~ normal(0,10);
  betaAb1 ~ normal(0,10);
  betaAb2 ~ normal(0,10);
  target += wt1[1]*multinomial_lpmf(y1[1,1:3] | theta3_1);
  target += wt1[2]*multinomial_lpmf(y1[2,1:4] | theta4_1);
  target += wt1[3]*multinomial_lpmf(y1[3,1:5] | theta5_1);
  target += wt1[4]*multinomial_lpmf(y1[4,1:6] | theta6_1);
  target += wt1[5]*multinomial_lpmf(y1[5,1:7] | theta7_1);
  target += wt1[6]*multinomial_lpmf(y1[6,1:8] | theta8_1);
  target += wt1[7]*multinomial_lpmf(y1[7,1:9] | theta9_1);
  target += wt1[8]*multinomial_lpmf(y1[8,1:10] | theta10_1);
  for (i in 1:(Na-8)) {
    target += wt1[(i+8)]*multinomial_lpmf(y1[(i+8),] | theta11_1[i]);
  }
  target += wt2[1]*multinomial_lpmf(y2[1,1:3] | theta3_2);
  target += wt2[2]*multinomial_lpmf(y2[2,1:4] | theta4_2);
  target += wt2[3]*multinomial_lpmf(y2[3,1:5] | theta5_2);
  target += wt2[4]*multinomial_lpmf(y2[4,1:6] | theta6_2);
  target += wt2[5]*multinomial_lpmf(y2[5,1:7] | theta7_2);
  target += wt2[6]*multinomial_lpmf(y2[6,1:8] | theta8_2);
  target += wt2[7]*multinomial_lpmf(y2[7,1:9] | theta9_2);
  target += wt2[8]*multinomial_lpmf(y2[8,1:10] | theta10_2);
  for (i in 1:(Na-8)) {
    target += wt2[(i+8)]*multinomial_lpmf(y2[(i+8),] | theta11_2[i]);
  }
}
