data {
  int N;
  int Nm;
  int Nf;
  int Nac;
  int Na;
  int Nab;
  int Nc72;
  int Nobs;
  int betadim;
  int succ[N];
  int tot[N];
  int ONSn[Nm];
  int ONSN[Nm];
  int y[Nac,3];
  int y1[Na,11];
  int y2[Na,11];
  int y3[Na,11];
  int ccind72[Nac];
  vector[Nac] cc72;
  int aind[Nac];
  vector[Na] a;
  vector[Nac] ac;
  int ab[Na,10];
  int Afind[Nm];
  int ACind[Nm];
  int yind[Nobs];
  vector[Nac] wtc;
  vector[Na] wt1c;
  vector[Na] wt2c;
  vector[Na] wt3c;
  vector[N] wt;
  matrix[N,betadim] X;
  matrix[Nf,betadim] Xf;
  matrix[N,3] Xq;
  matrix[Nf,3] Xqf;
  matrix[betadim,betadim] S1;
  matrix[betadim,betadim] S2;
  matrix[betadim,betadim] S3;
  matrix[betadim,betadim] S4;
  matrix[betadim,betadim] S5;
}

parameters {
  vector[betadim] beta;
  vector[2] betaQraw;
  real beta0;
  vector[2] beta0ACQ;
  vector[Nc72-1] betaC1raw;
  vector[Nc72-1] betaC2raw;
  vector[2] betaC;
  vector[Na-1] betaA2craw;
  real betaA;
  real<lower=0> sigmaA;
  vector[10] betaA1;
  vector[10] betaA2;
  vector[10] betaA3;
  vector[Nab] betaAb1;
  vector[Nab] betaAb2;
  vector[Nab] betaAb3;
  real<lower=0> sigmaAb;
  real<lower=0> tau1;
  real<lower=0> tau2;
  real<lower=0> tau3;
  real<lower=0> tau4;
  real<lower=0> tau5;
}

transformed parameters {
  vector[N] Y_hat;
  row_vector[betadim] betat;
  matrix[betadim,betadim] S;
  vector[3] betaQ;
  vector[Nf] Y_hatf;
  vector[Nf] eY_hatf;
  vector[Nm] psurv;
  vector[Nm] lpsurv;
  simplex[3] theta[Nac];
  matrix[Nac,3] Y_hatACQ;
  matrix[Na,11] Y_hat1AT;
  matrix[Na,11] Y_hat2AT;
  matrix[Na,11] Y_hat3AT;
  vector[Nc72] betaC1;
  vector[Nc72] betaC2;
  vector[Na] betaA2c;
  simplex[3] theta3_1;
  simplex[4] theta4_1;
  simplex[5] theta5_1;
  simplex[6] theta6_1;
  simplex[7] theta7_1;
  simplex[8] theta8_1;
  simplex[9] theta9_1;
  simplex[10] theta10_1;
  simplex[11] theta11_1[Na-8];
  simplex[3] theta3_2;
  simplex[4] theta4_2;
  simplex[5] theta5_2;
  simplex[6] theta6_2;
  simplex[7] theta7_2;
  simplex[8] theta8_2;
  simplex[9] theta9_2;
  simplex[10] theta10_2;
  simplex[11] theta11_2[Na-8];
  simplex[3] theta3_3;
  simplex[4] theta4_3;
  simplex[5] theta5_3;
  simplex[6] theta6_3;
  simplex[7] theta7_3;
  simplex[8] theta8_3;
  simplex[9] theta9_3;
  simplex[10] theta10_3;
  simplex[11] theta11_3[Na-8];
  matrix[30,11] Tprop1;
  matrix[30,11] Tprop2;
  matrix[30,11] Tprop3;
  betaQ[1] = 0;
  betaQ[2:3] = betaQraw;
  betaC1[1] = 0;
  betaC2[1] = 0;
  betaA2c[Na] = 0;
  betaC1[2:Nc72] = betaC1raw;
  betaC2[2:Nc72] = betaC2raw;
  betaA2c[1:(Na-1)] = betaA2craw;
  Y_hatACQ[,1] = rep_vector(0,Nac);
  Y_hatACQ[,2] = beta0ACQ[1] + betaC1[ccind72] + betaC[1]*cc72 + betaA*ac;
  Y_hatACQ[,3] = beta0ACQ[2] + betaC2[ccind72] + betaC[2]*cc72 + betaA2c[aind];
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Y_hatACQ[i,]));
  }
  Y_hat1AT[,1] = rep_vector(0,Na);
  Y_hat2AT[,1] = rep_vector(0,Na);
  Y_hat3AT[,1] = rep_vector(0,Na);
  for (i in 2:11) {
    Y_hat1AT[,i] = betaA1[i-1]*a + betaAb1[ab[,(i-1)]];
    Y_hat2AT[,i] = betaA2[i-1]*a + betaAb2[ab[,(i-1)]];
    Y_hat3AT[,i] = betaA3[i-1]*a + betaAb3[ab[,(i-1)]];
  }
  theta3_1 = softmax(to_vector(Y_hat1AT[1,1:3]));
  theta4_1 = softmax(to_vector(Y_hat1AT[2,1:4]));
  theta5_1 = softmax(to_vector(Y_hat1AT[3,1:5]));
  theta6_1 = softmax(to_vector(Y_hat1AT[4,1:6]));
  theta7_1 = softmax(to_vector(Y_hat1AT[5,1:7]));
  theta8_1 = softmax(to_vector(Y_hat1AT[6,1:8]));
  theta9_1 = softmax(to_vector(Y_hat1AT[7,1:9]));
  theta10_1 = softmax(to_vector(Y_hat1AT[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_1[i] = softmax(to_vector(Y_hat1AT[(i+8),]));
  }
  theta3_2 = softmax(to_vector(Y_hat2AT[1,1:3]));
  theta4_2 = softmax(to_vector(Y_hat2AT[2,1:4]));
  theta5_2 = softmax(to_vector(Y_hat2AT[3,1:5]));
  theta6_2 = softmax(to_vector(Y_hat2AT[4,1:6]));
  theta7_2 = softmax(to_vector(Y_hat2AT[5,1:7]));
  theta8_2 = softmax(to_vector(Y_hat2AT[6,1:8]));
  theta9_2 = softmax(to_vector(Y_hat2AT[7,1:9]));
  theta10_2 = softmax(to_vector(Y_hat2AT[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_2[i] = softmax(to_vector(Y_hat2AT[(i+8),]));
  }
  theta3_3 = softmax(to_vector(Y_hat3AT[1,1:3]));
  theta4_3 = softmax(to_vector(Y_hat3AT[2,1:4]));
  theta5_3 = softmax(to_vector(Y_hat3AT[3,1:5]));
  theta6_3 = softmax(to_vector(Y_hat3AT[4,1:6]));
  theta7_3 = softmax(to_vector(Y_hat3AT[5,1:7]));
  theta8_3 = softmax(to_vector(Y_hat3AT[6,1:8]));
  theta9_3 = softmax(to_vector(Y_hat3AT[7,1:9]));
  theta10_3 = softmax(to_vector(Y_hat3AT[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_3[i] = softmax(to_vector(Y_hat3AT[(i+8),]));
  }
  Tprop1[1,1:3] = to_row_vector(theta3_1);
  Tprop1[1,4:11] = rep_row_vector(0,8);
  Tprop1[2,1:4] = to_row_vector(theta4_1);
  Tprop1[2,5:11] = rep_row_vector(0,7);
  Tprop1[3,1:5] = to_row_vector(theta5_1);
  Tprop1[3,6:11] = rep_row_vector(0,6);
  Tprop1[4,1:6] = to_row_vector(theta6_1);
  Tprop1[4,7:11] = rep_row_vector(0,5);
  Tprop1[5,1:7] = to_row_vector(theta7_1);
  Tprop1[5,8:11] = rep_row_vector(0,4);
  Tprop1[6,1:8] = to_row_vector(theta8_1);
  Tprop1[6,9:11] = rep_row_vector(0,3);
  Tprop1[7,1:9] = to_row_vector(theta9_1);
  Tprop1[7,10:11] = rep_row_vector(0,2);
  Tprop1[8,1:10] = to_row_vector(theta10_1);
  Tprop1[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop1[(i+8),] = to_row_vector(theta11_1[i]);
  }
  Tprop2[1,1:3] = to_row_vector(theta3_2);
  Tprop2[1,4:11] = rep_row_vector(0,8);
  Tprop2[2,1:4] = to_row_vector(theta4_2);
  Tprop2[2,5:11] = rep_row_vector(0,7);
  Tprop2[3,1:5] = to_row_vector(theta5_2);
  Tprop2[3,6:11] = rep_row_vector(0,6);
  Tprop2[4,1:6] = to_row_vector(theta6_2);
  Tprop2[4,7:11] = rep_row_vector(0,5);
  Tprop2[5,1:7] = to_row_vector(theta7_2);
  Tprop2[5,8:11] = rep_row_vector(0,4);
  Tprop2[6,1:8] = to_row_vector(theta8_2);
  Tprop2[6,9:11] = rep_row_vector(0,3);
  Tprop2[7,1:9] = to_row_vector(theta9_2);
  Tprop2[7,10:11] = rep_row_vector(0,2);
  Tprop2[8,1:10] = to_row_vector(theta10_2);
  Tprop2[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop2[(i+8),] = to_row_vector(theta11_2[i]);
  }  
  Tprop3[1,1:3] = to_row_vector(theta3_3);
  Tprop3[1,4:11] = rep_row_vector(0,8);
  Tprop3[2,1:4] = to_row_vector(theta4_3);
  Tprop3[2,5:11] = rep_row_vector(0,7);
  Tprop3[3,1:5] = to_row_vector(theta5_3);
  Tprop3[3,6:11] = rep_row_vector(0,6);
  Tprop3[4,1:6] = to_row_vector(theta6_3);
  Tprop3[4,7:11] = rep_row_vector(0,5);
  Tprop3[5,1:7] = to_row_vector(theta7_3);
  Tprop3[5,8:11] = rep_row_vector(0,4);
  Tprop3[6,1:8] = to_row_vector(theta8_3);
  Tprop3[6,9:11] = rep_row_vector(0,3);
  Tprop3[7,1:9] = to_row_vector(theta9_3);
  Tprop3[7,10:11] = rep_row_vector(0,2);
  Tprop3[8,1:10] = to_row_vector(theta10_3);
  Tprop3[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop3[(i+8),] = to_row_vector(theta11_3[i]);
  }    
  S = S1/tau1 + S2/tau2 + S3/tau3 + S4/tau4 + S5/tau5;
  betat = beta';
  Y_hat = beta0 + Xq*betaQ + X*beta;
  Y_hatf = beta0 + Xqf*betaQ + Xf*beta;
  eY_hatf = inv_logit(Y_hatf);
  for (i in 1:Nm) {
    psurv[i] = Tprop1[Afind[i],1]*theta[ACind[i],1]*eY_hatf[i] +
    Tprop1[Afind[i],2]*theta[ACind[i],1]*eY_hatf[Nm+i] +
    Tprop1[Afind[i],3]*theta[ACind[i],1]*eY_hatf[2*Nm+i] +
    Tprop1[Afind[i],4]*theta[ACind[i],1]*eY_hatf[3*Nm+i] +
    Tprop1[Afind[i],5]*theta[ACind[i],1]*eY_hatf[4*Nm+i] +
    Tprop1[Afind[i],6]*theta[ACind[i],1]*eY_hatf[5*Nm+i] +
    Tprop1[Afind[i],7]*theta[ACind[i],1]*eY_hatf[6*Nm+i] +
    Tprop1[Afind[i],8]*theta[ACind[i],1]*eY_hatf[7*Nm+i] +
    Tprop1[Afind[i],9]*theta[ACind[i],1]*eY_hatf[8*Nm+i] +
    Tprop1[Afind[i],10]*theta[ACind[i],1]*eY_hatf[9*Nm+i] +
    Tprop1[Afind[i],11]*theta[ACind[i],1]*eY_hatf[10*Nm+i] +
    Tprop2[Afind[i],1]*theta[ACind[i],2]*eY_hatf[11*Nm+i] +
    Tprop2[Afind[i],2]*theta[ACind[i],2]*eY_hatf[12*Nm+i] +
    Tprop2[Afind[i],3]*theta[ACind[i],2]*eY_hatf[13*Nm+i] +
    Tprop2[Afind[i],4]*theta[ACind[i],2]*eY_hatf[14*Nm+i] +
    Tprop2[Afind[i],5]*theta[ACind[i],2]*eY_hatf[15*Nm+i] +
    Tprop2[Afind[i],6]*theta[ACind[i],2]*eY_hatf[16*Nm+i] +
    Tprop2[Afind[i],7]*theta[ACind[i],2]*eY_hatf[17*Nm+i] +
    Tprop2[Afind[i],8]*theta[ACind[i],2]*eY_hatf[18*Nm+i] +
    Tprop2[Afind[i],9]*theta[ACind[i],2]*eY_hatf[19*Nm+i] +
    Tprop2[Afind[i],10]*theta[ACind[i],2]*eY_hatf[20*Nm+i] +
    Tprop2[Afind[i],11]*theta[ACind[i],2]*eY_hatf[21*Nm+i] +
    Tprop3[Afind[i],1]*theta[ACind[i],3]*eY_hatf[22*Nm+i] +
    Tprop3[Afind[i],2]*theta[ACind[i],3]*eY_hatf[23*Nm+i] +
    Tprop3[Afind[i],3]*theta[ACind[i],3]*eY_hatf[24*Nm+i] +
    Tprop3[Afind[i],4]*theta[ACind[i],3]*eY_hatf[25*Nm+i] +
    Tprop3[Afind[i],5]*theta[ACind[i],3]*eY_hatf[26*Nm+i] +
    Tprop3[Afind[i],6]*theta[ACind[i],3]*eY_hatf[27*Nm+i] +
    Tprop3[Afind[i],7]*theta[ACind[i],3]*eY_hatf[28*Nm+i] +
    Tprop3[Afind[i],8]*theta[ACind[i],3]*eY_hatf[29*Nm+i] +
    Tprop3[Afind[i],9]*theta[ACind[i],3]*eY_hatf[30*Nm+i] +
    Tprop3[Afind[i],10]*theta[ACind[i],3]*eY_hatf[31*Nm+i] +
    Tprop3[Afind[i],11]*theta[ACind[i],3]*eY_hatf[32*Nm+i];
    }
  lpsurv = logit(psurv);
}

model {
  beta0 ~ normal(0,10);
  betaQraw ~ normal(0,10);
  tau1 ~ normal(0,10);
  tau2 ~ normal(0,10);
  tau3 ~ normal(0,10);
  tau4 ~ normal(0,10);
  tau5 ~ normal(0,10);
  beta0ACQ ~ normal(0,10);
  betaC1raw ~ normal(0,10);
  betaC2raw ~ normal(0,10);
  betaA ~ normal(0,10);
  betaC ~ normal(0,10);
  betaA2craw[1] ~ normal(0,10);
  for (i in 2:(Na-1)) {
    betaA2craw[i] ~ normal(betaA2craw[i-1],sigmaA);
  }
  sigmaA ~ normal(0,0.01);
  betaA1 ~ normal(0,10);
  betaA2 ~ normal(0,10);
  betaA3 ~ normal(0,10);
  betaAb1[1] ~ normal(0,10);
  betaAb2[1] ~ normal(0,10);
  betaAb3[1] ~ normal(0,10);
  for (i in 2:Nab) {
    betaAb1[i] ~ normal(betaAb1[i-1],sigmaAb);
    betaAb2[i] ~ normal(betaAb2[i-1],sigmaAb);
    betaAb3[i] ~ normal(betaAb3[i-1],sigmaAb);
  }
  sigmaAb ~ normal(0,0.01);
  for (i in yind) {
    target += wtc[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
  target += wt1c[3]*multinomial_lpmf(y1[3,1:5] | theta5_1);
  target += wt1c[4]*multinomial_lpmf(y1[4,1:6] | theta6_1);
  target += wt1c[5]*multinomial_lpmf(y1[5,1:7] | theta7_1);
  target += wt1c[6]*multinomial_lpmf(y1[6,1:8] | theta8_1);
  target += wt1c[7]*multinomial_lpmf(y1[7,1:9] | theta9_1);
  target += wt1c[8]*multinomial_lpmf(y1[8,1:10] | theta10_1);
  for (i in 1:(Na-8)) {
    target += wt1c[(i+8)]*multinomial_lpmf(y1[(i+8),] | theta11_1[i]);
  }
  target += wt2c[3]*multinomial_lpmf(y2[3,1:5] | theta5_2);
  target += wt2c[4]*multinomial_lpmf(y2[4,1:6] | theta6_2);
  target += wt2c[5]*multinomial_lpmf(y2[5,1:7] | theta7_2);
  target += wt2c[6]*multinomial_lpmf(y2[6,1:8] | theta8_2);
  target += wt2c[7]*multinomial_lpmf(y2[7,1:9] | theta9_2);
  target += wt2c[8]*multinomial_lpmf(y2[8,1:10] | theta10_2);
  for (i in 1:(Na-8)) {
    target += wt2c[(i+8)]*multinomial_lpmf(y2[(i+8),] | theta11_2[i]);
  }
  target += wt3c[3]*multinomial_lpmf(y3[3,1:5] | theta5_3);
  target += wt3c[4]*multinomial_lpmf(y3[4,1:6] | theta6_3);
  target += wt3c[5]*multinomial_lpmf(y3[5,1:7] | theta7_3);
  target += wt3c[6]*multinomial_lpmf(y3[6,1:8] | theta8_3);
  target += wt3c[7]*multinomial_lpmf(y3[7,1:9] | theta9_3);
  target += wt3c[8]*multinomial_lpmf(y3[8,1:10] | theta10_3);
  for (i in 1:(Na-8)) {
    target += wt3c[(i+8)]*multinomial_lpmf(y3[(i+8),] | theta11_3[i]);
  }  
  for (n in 1:N) {
    target += 0.9995*wt[n]*binomial_logit_lpmf(succ[n] | tot[n], Y_hat[n]);
  }
  for (m in 1:Nm) {
    target += 0.0005*binomial_logit_lpmf(ONSn[m] | ONSN[m], lpsurv[m]);
  }
  target += 0.5*log_determinant(S)-0.5*betat*S*beta;
}
