data {
  int Nac;
  int Nc72;
  int Na;
  int Nc;
  int Nobs;
  int y[Nac,3];
  int ccind72[Nac];
  vector[Nac] cc;
  vector[Nac] cc72;
  int aind[Nac];
  vector[Nac] a;
  int yind[Nobs];
  vector[Nac] wt;
}

parameters {
  vector[2] beta0;
  vector[2] betaC;
}

transformed parameters {
  simplex[3] theta[Nac];
  matrix[Nac,3] Yhat;
  Yhat[,1] = rep_vector(0,Nac);
  for (i in 2:3) {
    Yhat[,i] = beta0[i-1] + betaC[i-1]*cc;
  }
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC ~ normal(0,10);
  for (i in yind) {
    target += wt[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
}
