data {
  int Nac;
  int Nc72;
  int Na;
  int Nobs;
  int y[Nac,3];
  int ccind72[Nac];
  vector[Nac] cc72;
  int aind[Nac];
  vector[Nac] a;
  int yind[Nobs];
  vector[Nac] wt;
}

parameters {
  vector[2] beta0;
  vector[Nc72-1] betaC1raw;
  vector[Nc72-1] betaC2raw;
  vector[2] betaC;
  vector[Na-1] betaA2raw;
  real betaA;
  real<lower=0> sigmaA2;
}

transformed parameters {
  simplex[3] theta[Nac];
  matrix[Nac,3] Yhat;
  vector[Nc72] betaC1;
  vector[Nc72] betaC2;
  vector[Na] betaA2;
  betaC1[1] = 0;
  betaC2[1] = 0;
  betaA2[Na] = 0;
  betaC1[2:Nc72] = betaC1raw;
  betaC2[2:Nc72] = betaC2raw;
  betaA2[1:(Na-1)] = betaA2raw;
  Yhat[,1] = rep_vector(0,Nac);
  Yhat[,2] = beta0[1] + betaC1[ccind72] + betaC[1]*cc72 + betaA*a;
  Yhat[,3] = beta0[2] + betaC2[ccind72] + betaC[2]*cc72 + betaA2[aind];
  for (i in 1:Nac) {
    theta[i] = softmax(to_vector(Yhat[i,]));
  }
}

model {
  beta0 ~ normal(0,10);
  betaC ~ normal(0,10);
  betaC1raw ~ normal(0,10);
  betaC2raw ~ normal(0,10);
  betaA2raw[1] ~ normal(0,10);
  for (i in 2:(Na-1)) {
    betaA2raw[i] ~ normal(betaA2raw[i-1],sigmaA2);
  }
  sigmaA2 ~ normal(0,0.01);
  betaA ~ normal(0,10);
  for (i in yind) {
    target += wt[i] * multinomial_lpmf(y[i,] | theta[i]);
  }
}
