data {
  int Na;
  int Nab;
  int y1[Na,11];
  int y2[Na,11];
  int y3[Na,11];
  vector[Na] a;
  vector[Na] a2;
  int ab[Na,10];
  vector[Na] wt1;
  vector[Na] wt2;
  vector[Na] wt3;
}

parameters {
  vector[10] betaA;
  vector[10] betaA_21;
  vector[10] betaA_22;
  vector[10] betaA_23;
  vector[Nab] betaAb;
}

transformed parameters {
  simplex[3] theta3_1;
  simplex[4] theta4_1;
  simplex[5] theta5_1;
  simplex[6] theta6_1;
  simplex[7] theta7_1;
  simplex[8] theta8_1;
  simplex[9] theta9_1;
  simplex[10] theta10_1;
  simplex[11] theta11_1[Na-8];
  simplex[3] theta3_2;
  simplex[4] theta4_2;
  simplex[5] theta5_2;
  simplex[6] theta6_2;
  simplex[7] theta7_2;
  simplex[8] theta8_2;
  simplex[9] theta9_2;
  simplex[10] theta10_2;
  simplex[11] theta11_2[Na-8];
  simplex[3] theta3_3;
  simplex[4] theta4_3;
  simplex[5] theta5_3;
  simplex[6] theta6_3;
  simplex[7] theta7_3;
  simplex[8] theta8_3;
  simplex[9] theta9_3;
  simplex[10] theta10_3;
  simplex[11] theta11_3[Na-8];
  matrix[Na,11] Yhat_1;
  matrix[Na,11] Yhat_2;
  matrix[Na,11] Yhat_3;
  matrix[Na,11] Tprop1;
  matrix[Na,11] Tprop2;
  matrix[Na,11] Tprop3;
  Yhat_1[,1] = rep_vector(0,Na);
  Yhat_2[,1] = rep_vector(0,Na);
  Yhat_3[,1] = rep_vector(0,Na);
  for (i in 2:11) {
    Yhat_1[,i] = betaA[i-1]*a + betaA_21[i-1]*a2 + betaAb[ab[,(i-1)]];
    Yhat_2[,i] = betaA[i-1]*a + betaA_22[i-1]*a2 + betaAb[ab[,(i-1)]];
    Yhat_3[,i] = betaA[i-1]*a + betaA_23[i-1]*a2 + betaAb[ab[,(i-1)]];
  }
  theta3_1 = softmax(to_vector(Yhat_1[1,1:3]));
  theta4_1 = softmax(to_vector(Yhat_1[2,1:4]));
  theta5_1 = softmax(to_vector(Yhat_1[3,1:5]));
  theta6_1 = softmax(to_vector(Yhat_1[4,1:6]));
  theta7_1 = softmax(to_vector(Yhat_1[5,1:7]));
  theta8_1 = softmax(to_vector(Yhat_1[6,1:8]));
  theta9_1 = softmax(to_vector(Yhat_1[7,1:9]));
  theta10_1 = softmax(to_vector(Yhat_1[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_1[i] = softmax(to_vector(Yhat_1[(i+8),]));
  }
  theta3_2 = softmax(to_vector(Yhat_2[1,1:3]));
  theta4_2 = softmax(to_vector(Yhat_2[2,1:4]));
  theta5_2 = softmax(to_vector(Yhat_2[3,1:5]));
  theta6_2 = softmax(to_vector(Yhat_2[4,1:6]));
  theta7_2 = softmax(to_vector(Yhat_2[5,1:7]));
  theta8_2 = softmax(to_vector(Yhat_2[6,1:8]));
  theta9_2 = softmax(to_vector(Yhat_2[7,1:9]));
  theta10_2 = softmax(to_vector(Yhat_2[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_2[i] = softmax(to_vector(Yhat_2[(i+8),]));
  }
  theta3_3 = softmax(to_vector(Yhat_3[1,1:3]));
  theta4_3 = softmax(to_vector(Yhat_3[2,1:4]));
  theta5_3 = softmax(to_vector(Yhat_3[3,1:5]));
  theta6_3 = softmax(to_vector(Yhat_3[4,1:6]));
  theta7_3 = softmax(to_vector(Yhat_3[5,1:7]));
  theta8_3 = softmax(to_vector(Yhat_3[6,1:8]));
  theta9_3 = softmax(to_vector(Yhat_3[7,1:9]));
  theta10_3 = softmax(to_vector(Yhat_3[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11_3[i] = softmax(to_vector(Yhat_3[(i+8),]));
  }
  Tprop1[1,1:3] = to_row_vector(theta3_1);
  Tprop1[1,4:11] = rep_row_vector(0,8);
  Tprop1[2,1:4] = to_row_vector(theta4_1);
  Tprop1[2,5:11] = rep_row_vector(0,7);
  Tprop1[3,1:5] = to_row_vector(theta5_1);
  Tprop1[3,6:11] = rep_row_vector(0,6);
  Tprop1[4,1:6] = to_row_vector(theta6_1);
  Tprop1[4,7:11] = rep_row_vector(0,5);
  Tprop1[5,1:7] = to_row_vector(theta7_1);
  Tprop1[5,8:11] = rep_row_vector(0,4);
  Tprop1[6,1:8] = to_row_vector(theta8_1);
  Tprop1[6,9:11] = rep_row_vector(0,3);
  Tprop1[7,1:9] = to_row_vector(theta9_1);
  Tprop1[7,10:11] = rep_row_vector(0,2);
  Tprop1[8,1:10] = to_row_vector(theta10_1);
  Tprop1[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop1[(i+8),] = to_row_vector(theta11_1[i]);
  }
  Tprop2[1,1:3] = to_row_vector(theta3_2);
  Tprop2[1,4:11] = rep_row_vector(0,8);
  Tprop2[2,1:4] = to_row_vector(theta4_2);
  Tprop2[2,5:11] = rep_row_vector(0,7);
  Tprop2[3,1:5] = to_row_vector(theta5_2);
  Tprop2[3,6:11] = rep_row_vector(0,6);
  Tprop2[4,1:6] = to_row_vector(theta6_2);
  Tprop2[4,7:11] = rep_row_vector(0,5);
  Tprop2[5,1:7] = to_row_vector(theta7_2);
  Tprop2[5,8:11] = rep_row_vector(0,4);
  Tprop2[6,1:8] = to_row_vector(theta8_2);
  Tprop2[6,9:11] = rep_row_vector(0,3);
  Tprop2[7,1:9] = to_row_vector(theta9_2);
  Tprop2[7,10:11] = rep_row_vector(0,2);
  Tprop2[8,1:10] = to_row_vector(theta10_2);
  Tprop2[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop2[(i+8),] = to_row_vector(theta11_2[i]);
  }  
  Tprop3[1,1:3] = to_row_vector(theta3_3);
  Tprop3[1,4:11] = rep_row_vector(0,8);
  Tprop3[2,1:4] = to_row_vector(theta4_3);
  Tprop3[2,5:11] = rep_row_vector(0,7);
  Tprop3[3,1:5] = to_row_vector(theta5_3);
  Tprop3[3,6:11] = rep_row_vector(0,6);
  Tprop3[4,1:6] = to_row_vector(theta6_3);
  Tprop3[4,7:11] = rep_row_vector(0,5);
  Tprop3[5,1:7] = to_row_vector(theta7_3);
  Tprop3[5,8:11] = rep_row_vector(0,4);
  Tprop3[6,1:8] = to_row_vector(theta8_3);
  Tprop3[6,9:11] = rep_row_vector(0,3);
  Tprop3[7,1:9] = to_row_vector(theta9_3);
  Tprop3[7,10:11] = rep_row_vector(0,2);
  Tprop3[8,1:10] = to_row_vector(theta10_3);
  Tprop3[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop3[(i+8),] = to_row_vector(theta11_3[i]);
  } 
}

model {
  betaA ~ normal(0,10);
  betaA_21 ~ normal(0,10);
  betaA_22 ~ normal(0,10);
  betaA_23 ~ normal(0,10);
  betaAb ~ normal(0,10);
  target += wt1[3]*multinomial_lpmf(y1[3,1:5] | theta5_1);
  target += wt1[4]*multinomial_lpmf(y1[4,1:6] | theta6_1);
  target += wt1[5]*multinomial_lpmf(y1[5,1:7] | theta7_1);
  target += wt1[6]*multinomial_lpmf(y1[6,1:8] | theta8_1);
  target += wt1[7]*multinomial_lpmf(y1[7,1:9] | theta9_1);
  target += wt1[8]*multinomial_lpmf(y1[8,1:10] | theta10_1);
  for (i in 1:(Na-8)) {
    target += wt1[(i+8)]*multinomial_lpmf(y1[(i+8),] | theta11_1[i]);
  }
  target += wt2[3]*multinomial_lpmf(y2[3,1:5] | theta5_2);
  target += wt2[4]*multinomial_lpmf(y2[4,1:6] | theta6_2);
  target += wt2[5]*multinomial_lpmf(y2[5,1:7] | theta7_2);
  target += wt2[6]*multinomial_lpmf(y2[6,1:8] | theta8_2);
  target += wt2[7]*multinomial_lpmf(y2[7,1:9] | theta9_2);
  target += wt2[8]*multinomial_lpmf(y2[8,1:10] | theta10_2);
  for (i in 1:(Na-8)) {
    target += wt2[(i+8)]*multinomial_lpmf(y2[(i+8),] | theta11_2[i]);
  }
  target += wt3[3]*multinomial_lpmf(y3[3,1:5] | theta5_3);
  target += wt3[4]*multinomial_lpmf(y3[4,1:6] | theta6_3);
  target += wt3[5]*multinomial_lpmf(y3[5,1:7] | theta7_3);
  target += wt3[6]*multinomial_lpmf(y3[6,1:8] | theta8_3);
  target += wt3[7]*multinomial_lpmf(y3[7,1:9] | theta9_3);
  target += wt3[8]*multinomial_lpmf(y3[8,1:10] | theta10_3);
  for (i in 1:(Na-8)) {
    target += wt3[(i+8)]*multinomial_lpmf(y3[(i+8),] | theta11_3[i]);
  }
}
