data {
  int Na;
  int Nab;
  int y[Na,11];
  vector[Na] a;
  vector[Na] a2;
  int ab[Na,10];
  vector[Na] wt;
}

parameters {
  vector[10] betaA;
  vector[10] betaA2;
  vector[Nab] betaAb;
}

transformed parameters {
  simplex[3] theta3;
  simplex[4] theta4;
  simplex[5] theta5;
  simplex[6] theta6;
  simplex[7] theta7;
  simplex[8] theta8;
  simplex[9] theta9;
  simplex[10] theta10;
  simplex[11] theta11[Na-8];
  matrix[Na,11] Yhat;
  matrix[Na,11] Tprop;
  Yhat[,1] = rep_vector(0,Na);
  for (i in 2:11) {
    Yhat[,i] = betaA[i-1]*a + betaA2[i-1]*a2 + betaAb[ab[,(i-1)]];
  }
  theta3 = softmax(to_vector(Yhat[1,1:3]));
  theta4 = softmax(to_vector(Yhat[2,1:4]));
  theta5 = softmax(to_vector(Yhat[3,1:5]));
  theta6 = softmax(to_vector(Yhat[4,1:6]));
  theta7 = softmax(to_vector(Yhat[5,1:7]));
  theta8 = softmax(to_vector(Yhat[6,1:8]));
  theta9 = softmax(to_vector(Yhat[7,1:9]));
  theta10 = softmax(to_vector(Yhat[8,1:10]));
  for (i in 1:(Na-8)) {
    theta11[i] = softmax(to_vector(Yhat[(i+8),]));
  }
  Tprop[1,1:3] = to_row_vector(theta3);
  Tprop[1,4:11] = rep_row_vector(0,8);
  Tprop[2,1:4] = to_row_vector(theta4);
  Tprop[2,5:11] = rep_row_vector(0,7);
  Tprop[3,1:5] = to_row_vector(theta5);
  Tprop[3,6:11] = rep_row_vector(0,6);
  Tprop[4,1:6] = to_row_vector(theta6);
  Tprop[4,7:11] = rep_row_vector(0,5);
  Tprop[5,1:7] = to_row_vector(theta7);
  Tprop[5,8:11] = rep_row_vector(0,4);
  Tprop[6,1:8] = to_row_vector(theta8);
  Tprop[6,9:11] = rep_row_vector(0,3);
  Tprop[7,1:9] = to_row_vector(theta9);
  Tprop[7,10:11] = rep_row_vector(0,2);
  Tprop[8,1:10] = to_row_vector(theta10);
  Tprop[8,11] = 0;
  for (i in 1:(Na-8)) {
    Tprop[(i+8),] = to_row_vector(theta11[i]);
  }
}

model {
  betaA ~ normal(0,10);
  betaA2 ~ normal(0,10);
  betaAb ~ normal(0,10);
  target += wt[4]*multinomial_lpmf(y[4,1:6] | theta6);
  target += wt[5]*multinomial_lpmf(y[5,1:7] | theta7);
  target += wt[6]*multinomial_lpmf(y[6,1:8] | theta8);
  target += wt[7]*multinomial_lpmf(y[7,1:9] | theta9);
  target += wt[8]*multinomial_lpmf(y[8,1:10] | theta10);
  for (i in 1:(Na-8)) {
    target += wt[(i+8)]*multinomial_lpmf(y[(i+8),] | theta11[i]);
  }
}
